package org.openmhp.system;

import org.openmhp.application.*;
import java.io.*;
import java.net.*;

import org.openmhp.util.Out;
/**
* @author tejopa
*/
public class ADBRequestHandler {

	private AppsDatabaseImpl appsDatabaseImpl;
	private Socket socket;
	boolean isAlive = false;
	AppsDatabaseServer server;
	ObjectInputStream ois;
	ObjectOutputStream ous;

	public ADBRequestHandler(Socket s, AppsDatabaseImpl appsdb, AppsDatabaseServer sv) {
		socket =s;
		appsDatabaseImpl = appsdb;
		server = sv;
		try {
			ois = new ObjectInputStream(socket.getInputStream());
			ous = new ObjectOutputStream(socket.getOutputStream());

			ADBRequest request = (ADBRequest)ois.readObject();
			int requestId = request.getType();

			switch (requestId) {

				/*
				Request returns a vector containing data from method AppDatabaseImpl.getData().
				So, the elements are SerializedAppdata objects. Client constructs a database
				with that information.
				*/
				case ADBRequest.DATABASE_REQUEST:
						Out.printMe(Out.TRACE,"DATABASE REQUESTED");
						ous.writeObject(new ADBRequest(ADBRequest.DATABASE_RESPONSE,appsdb.getData()));
						isAlive = false;
						break;
				case ADBRequest.XLET_INIT:
						Out.printMe(Out.TRACE,"XLET_INIT");
						isAlive = false;
						break;
				case ADBRequest.XLET_START:
						Out.printMe(Out.TRACE,"XLET_START");
						isAlive = false;
						break;
				case ADBRequest.XLET_PAUSE:
						Out.printMe(Out.TRACE,"XLET_PAUSE");
						isAlive = false;
						break;
				case ADBRequest.XLET_DESTROY:
						Out.printMe(Out.TRACE,"XLET_DESTROY");
						isAlive = false;
						break;
				case ADBRequest.XLET_CONNECTION:
						Out.printMe(Out.TRACE,"XLET_CONNECTION");
						server.xlethandlers.add(this);
						Out.printMe(Out.TRACE,"Currently "+server.xlethandlers.size()+" xletconnections");
						isAlive = false;
						new XletReceiver();
						//new XletSender().start();
						break;


			}
			ous.flush();
			if (!isAlive()) {
				ous.close();
				ois.close();
				socket.close();
			}
		}
		catch (Exception e) {
			Out.error(this,e.toString());
		}

	}

	public boolean isAlive() {
		if (!socket.isConnected()) { return false; }
		else {
			return isAlive;
		}
	}

	public void sendStart() {
		Out.printMe(Out.TRACE);
		ADBRequest request = new ADBRequest(ADBRequest.XLET_START,null);
		try {
			ous.writeObject(request);
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"Could not open xletconnection "+e.toString());
		}
	}

	class XletReceiver implements Runnable {
		public XletReceiver() {
			new Thread(this).start();
		}
		public void run() {
			Out.printMe(Out.TRACE,"Connection started");
			while (isAlive()) {
				try {
					Object o = ois.readObject();
					Thread.currentThread().sleep(1000);
				}
				catch (Exception e) {
					Out.printMe(Out.ERROR,e.toString());
					isAlive = false;
				}
			}
			isAlive = false;
			server.cleanUp();
		}
	}


//		ObjectOutputStream ous = new ObjectOutputStream(s.getOutputStream());


}