package org.openmhp.system;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import org.havi.ui.event.*;

import org.dvb.event.*;
import java.util.*;
import org.openmhp.util.*;
import java.io.*;
import org.openmhp.adaptation.event.*;

public class EmulatorRemote extends JFrame implements ActionListener, KeyListener, MouseListener {

	private String PROPS_PATH = "";
	public Container container;
	private EventManager eventManager;

	private Hashtable keys;
	Box rlayout = new Box(BoxLayout.Y_AXIS);

	EventServer eventServer;

  	public EmulatorRemote () {
    	super("RemoteControl");
    	setResizable(false);
		setFocusableWindowState(false);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE );

		getContentPane().add(rlayout);

		eventManager = EventManager.getInstance();

		addKeyListener(this);
    	addMouseListener(this);

		init();
		PROPS_PATH = Constants.ROOT+java.io.File.separator+"static"+java.io.File.separator+"remotecontrol.keymap";
		//PROPS_PATH+=java.io.File.separator+"static"+java.io.File.separator;
		setKeymap(PROPS_PATH);


    	setVisible(true);
    	pack();
    	repaint();
    	validate();
		
		//eventServer = EventServer.getInstance("127.0.0.1");
	}


	public void init() {
		keys = new Hashtable();
		keys.put("VK_ESCAPE",					new Integer(KeyEvent.VK_ESCAPE));
		keys.put("VK_TELETEXT", 				new Integer(HRcEvent.VK_TELETEXT));
		keys.put("VK_COLORED_KEY_0",			new Integer(HRcEvent.VK_COLORED_KEY_0));
		keys.put("VK_COLORED_KEY_1",			new Integer(HRcEvent.VK_COLORED_KEY_1));
		keys.put("VK_COLORED_KEY_2",			new Integer(HRcEvent.VK_COLORED_KEY_2));
		keys.put("VK_COLORED_KEY_3",			new Integer(HRcEvent.VK_COLORED_KEY_3));
		keys.put("VK_COLORED_KEY_4",			new Integer(HRcEvent.VK_COLORED_KEY_4));
		keys.put("VK_COLORED_KEY_5",			new Integer(HRcEvent.VK_COLORED_KEY_5));
		keys.put("VK_HELP",						new Integer(KeyEvent.VK_HELP));
		keys.put("VK_SCREEN_MODE_NEXT",			new Integer(HRcEvent.VK_SCREEN_MODE_NEXT));
		keys.put("VK_SUBTITLE",					new Integer(HRcEvent.VK_SUBTITLE));
		keys.put("VK_INFO",						new Integer(HRcEvent.VK_INFO));
		keys.put("VK_GUIDE",					new Integer(HRcEvent.VK_GUIDE));
		keys.put("VK_ENTER",					new Integer(HRcEvent.VK_ENTER));
		keys.put("VK_CANCEL",					new Integer(KeyEvent.VK_CANCEL));
		keys.put("VK_UP",						new Integer(KeyEvent.VK_UP));
		keys.put("VK_LEFT",						new Integer(KeyEvent.VK_LEFT));
		keys.put("VK_RIGHT",					new Integer(KeyEvent.VK_RIGHT));
		keys.put("VK_DOWN",						new Integer(KeyEvent.VK_DOWN));
		keys.put("VK_VOLUME_UP",				new Integer(HRcEvent.VK_VOLUME_UP));
		keys.put("VK_VOLUME_DOWN",				new Integer(HRcEvent.VK_VOLUME_DOWN));
		keys.put("VK_CHANNEL_UP",				new Integer(HRcEvent.VK_CHANNEL_UP));
		keys.put("VK_CHANNEL_DOWN",				new Integer(HRcEvent.VK_CHANNEL_DOWN));
		keys.put("VK_MUTE",						new Integer(HRcEvent.VK_MUTE));
		keys.put("VK_1",						new Integer(KeyEvent.VK_1));
		keys.put("VK_2",						new Integer(KeyEvent.VK_2));
		keys.put("VK_3",						new Integer(KeyEvent.VK_3));
		keys.put("VK_4",						new Integer(KeyEvent.VK_4));
		keys.put("VK_5",						new Integer(KeyEvent.VK_5));
		keys.put("VK_6",						new Integer(KeyEvent.VK_6));
		keys.put("VK_7",						new Integer(KeyEvent.VK_7));
		keys.put("VK_8",						new Integer(KeyEvent.VK_8));
		keys.put("VK_9",						new Integer(KeyEvent.VK_9));
		keys.put("VK_0",						new Integer(KeyEvent.VK_0));
		keys.put("VK_SPACE",					new Integer(KeyEvent.VK_SPACE));
		keys.put("VK_POWER",					new Integer(HRcEvent.VK_POWER));
		keys.put("VK_DIMMER",					new Integer(HRcEvent.VK_DIMMER));
		keys.put("VK_WINK",						new Integer(HRcEvent.VK_WINK));;
		keys.put("VK_REWIND",					new Integer(HRcEvent.VK_REWIND));
		keys.put("VK_STOP",						new Integer(HRcEvent.VK_STOP));
		keys.put("VK_EJECT_TOGGLE",				new Integer(HRcEvent.VK_EJECT_TOGGLE));
		keys.put("VK_PLAY",						new Integer(HRcEvent.VK_PLAY));
		keys.put("VK_RECORD",					new Integer(HRcEvent.VK_RECORD));
		keys.put("VK_FAST_FWD",					new Integer(HRcEvent.VK_FAST_FWD));
		keys.put("VK_PLAY_SPEED_UP",			new Integer(HRcEvent.VK_PLAY_SPEED_UP));
		keys.put("VK_PLAY_SPEED_DOWN",			new Integer(HRcEvent.VK_PLAY_SPEED_DOWN));
		keys.put("VK_PLAY_SPEED_RESET",			new Integer(HRcEvent.VK_PLAY_SPEED_RESET));
		keys.put("VK_RECORD_SPEED_NEXT",		new Integer(HRcEvent.VK_RECORD_SPEED_NEXT));
		keys.put("VK_GO_TO_START",				new Integer(HRcEvent.VK_GO_TO_START));
		keys.put("VK_GO_TO_END",				new Integer(HRcEvent.VK_GO_TO_END));
		keys.put("VK_TRACK_PREV",				new Integer(HRcEvent.VK_TRACK_PREV));
		keys.put("VK_TRACK_NEXT",				new Integer(HRcEvent.VK_TRACK_NEXT));
		keys.put("VK_RANDOM_TOGGLE",			new Integer(HRcEvent.VK_RANDOM_TOGGLE));
		keys.put("VK_STORE_FAVORITE_0",			new Integer(HRcEvent.VK_STORE_FAVORITE_0));
		keys.put("VK_STORE_FAVORITE_1",			new Integer(HRcEvent.VK_STORE_FAVORITE_1));
		keys.put("VK_STORE_FAVORITE_2",			new Integer(HRcEvent.VK_STORE_FAVORITE_2));
		keys.put("VK_STORE_FAVORITE_3",			new Integer(HRcEvent.VK_STORE_FAVORITE_3));
		keys.put("VK_RECALL_FAVORITE_0",		new Integer(HRcEvent.VK_RECALL_FAVORITE_0));
		keys.put("VK_RECALL_FAVORITE_1",		new Integer(HRcEvent.VK_RECALL_FAVORITE_1));
		keys.put("VK_RECALL_FAVORITE_2",		new Integer(HRcEvent.VK_RECALL_FAVORITE_2));
		keys.put("VK_RECALL_FAVORITE_3",		new Integer(HRcEvent.VK_RECALL_FAVORITE_3));
		keys.put("VK_CLEAR_FAVORITE_0",			new Integer(HRcEvent.VK_CLEAR_FAVORITE_0));
		keys.put("VK_CLEAR_FAVORITE_1",			new Integer(HRcEvent.VK_CLEAR_FAVORITE_1));
		keys.put("VK_CLEAR_FAVORITE_2",			new Integer(HRcEvent.VK_CLEAR_FAVORITE_2));
		keys.put("VK_CLEAR_FAVORITE_3",			new Integer(HRcEvent.VK_CLEAR_FAVORITE_3));
		keys.put("VK_SCAN_CHANNELS_TOGGLE",		new Integer(HRcEvent.VK_SCAN_CHANNELS_TOGGLE));
		keys.put("VK_PINP_TOGGLE",				new Integer(HRcEvent.VK_PINP_TOGGLE));
		keys.put("VK_SPLIT_SCREEN_TOGGLE",		new Integer(HRcEvent.VK_SPLIT_SCREEN_TOGGLE));
		keys.put("VK_DISPLAY_SWAP",				new Integer(HRcEvent.VK_DISPLAY_SWAP));
		keys.put("VK_VIDEO_MODE_NEXT",			new Integer(HRcEvent.VK_VIDEO_MODE_NEXT));
		keys.put("VK_SURROUND_MODE_NEXT",		new Integer(HRcEvent.VK_SURROUND_MODE_NEXT));
		keys.put("VK_BALANCE_RIGHT",			new Integer(HRcEvent.VK_BALANCE_RIGHT));
		keys.put("VK_BALANCE_LEFT",				new Integer(HRcEvent.VK_BALANCE_LEFT));
		keys.put("VK_FADER_FRONT",				new Integer(HRcEvent.VK_FADER_FRONT));
		keys.put("VK_FADER_REAR",				new Integer(HRcEvent.VK_FADER_REAR));
		keys.put("VK_BASS_BOOST_UP",			new Integer(HRcEvent.VK_BASS_BOOST_UP));
		keys.put("VK_BASS_BOOST_DOWN",			new Integer(HRcEvent.VK_BASS_BOOST_DOWN));
	}





	public void addLine(RButton[] bs) {
		//Box line = new Box(BoxLayout.X_AXIS);
		JPanel line = new JPanel();
		line.setLayout(new GridLayout(1,bs.length));
		line.setSize(80,120);
		int w = getWidth();
		int cw = w/bs.length;
		for (int i=0;i<bs.length;i++) {
			line.add(bs[i]);
			bs[i].addActionListener(this);
			bs[i].setSize(cw,30);
		}
		rlayout.add(line);


	}

	class RButton extends JButton{
		public int keyCode = 0;
		String presentation = "";
		String imagefile = "";
		Image img;
		public RButton(String kc, String p, String i) {
				super();
				try {
					keyCode = ((Integer)keys.get(kc)).intValue();
					setText(p);
					imagefile = i;
					setSize(30,30);
					if (imagefile.trim()!="") {
						ImageIcon icon = new ImageIcon(Constants.ROOT+java.io.File.separator+"static"+java.io.File.separator+imagefile);
						setIcon(icon);
						setText("");
						setSize(icon.getIconWidth(),icon.getIconHeight());
					}
				}
				catch (Exception e) {
					keyCode = -1;
					setText(" ");
					imagefile = i;
				}
		}


	}

	public void actionPerformed(ActionEvent e) {
		System.out.println(e);
		RButton b = (RButton)e.getSource();
		System.out.println(b.keyCode);
		eventManager.fireUserEvent(this,new KeyEvent(this, KeyEvent.KEY_PRESSED, System.currentTimeMillis(), 0, b.keyCode));
		//eventServer.sendEvent(new KeyEvent(this, KeyEvent.KEY_PRESSED, System.currentTimeMillis(), 0, b.keyCode));
	}


	public static void main(String[] args) {
		new EmulatorRemote();
	}



	public void mouseClicked(MouseEvent e) {

  	}

	public void mousePressed(MouseEvent e) {   }
	public void mouseReleased(MouseEvent e) { }
	public void mouseEntered(MouseEvent e) { }
	public void mouseExited(MouseEvent e) { }



	public void keyPressed(KeyEvent e)	{	}
	public void keyTyped(KeyEvent e)	{	}
	public void keyReleased(KeyEvent e) {	}




	public void setKeymap(String file) {
		try {
			BufferedReader br = new BufferedReader(new FileReader(new File(file)));
			String line = "";
			while ((line = br.readLine())!=null) {
				String[] k = line.split(">");
				RButton[] buttons = new RButton[k.length];
				for (int i=0;i<k.length;i++) {
					String[] pairs = k[i].split(" ");

					String string = " ";
					String keycode = "";
					String image = "";
					for (int j=0;j<pairs.length;j++) {
						String curr = pairs[j];
						if (curr.length()<5) {
							break;
						}
						if (curr.indexOf("empty")!=-1) {
							string =" ";
							keycode = " ";
							break;
						}
						if (curr.indexOf("string")!=-1) {
							int s = curr.indexOf("\"");
							curr = curr.substring(s+1,curr.length());
							string = curr.substring(0,curr.indexOf("\""));
						}
						if (curr.indexOf("keycode")!=-1) {
							int s = curr.indexOf("\"");
							curr = curr.substring(s+1,curr.length());
							keycode = curr.substring(0,curr.indexOf("\""));
						}
						if (curr.indexOf("image")!=-1) {
							int s = curr.indexOf("\"");
							curr = curr.substring(s+1,curr.length());
							image = curr.substring(0,curr.indexOf("\""));
						}
					}
					buttons[i] = new RButton(keycode,string,image);
				}
				addLine(buttons);
			}

		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,e.toString());
			e.printStackTrace();
		}


	}



}

