package org.openmhp.system;

import java.util.*;
import java.io.*;

import org.openmhp.util.LinkedList;
import org.openmhp.util.Out;

/**
*
* This class reads and writes projects to and from file system.
*
* @author tejopa
* @date 13.2.2004
* @status partially implemented
* @module internal
*/
public class ProjectHandler {

	Properties allProjects;
	String currentPath = "";
	LinkedList projectList;
	

	/** Create project handler for a given directory */
	public ProjectHandler(String directory) {
		currentPath = directory;
                System.out.println("MHP PH: directory set to: " + currentPath);
		//allProjects = loadProperties(currentPath);
	}

	public Project[] getProjects() {
		loadProjects(currentPath);
		Project[] temp = new Project[projectList.size()];
		for (int i=0;i<projectList.size();i++) {
			temp[i] = (Project)projectList.get(i);	
		}
		return temp;	
	}

	private void loadProjects(String dir) {
		projectList = new LinkedList();
		File directory = new File(dir);
		if (directory.exists()) {
			String[] files = directory.list();
			for (int i=0;i<files.length;i++) {
				Properties currProps = loadProperties(currentPath+File.separator+files[i]);								
				Project currProject = getProject(currProps);
				if (currProject!=null) {
					currProject.projectFile=currentPath+File.separator+files[i];
					projectList.add(currProject);
				}			
			}
		}	
		else {
			Out.printMe(Out.ERROR,"Directory "+directory+" does not exist");
		}
	}

	public static Properties loadProperties(String filename) {
		Properties p = new Properties();
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(filename);
			try {	p.load(fis);	}
			catch (IOException e) {
				System.out.println(e.toString());
				}
			}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"Error while loading properties file >"+filename+"< "+e.toString());
			}
		//System.out.println("Properties file >"+filename+"< loaded.");
		return p;
	}

	public static void saveProperties(String filename, Properties props) {
		FileOutputStream fos = null;
		try {
			fos = new FileOutputStream(filename);
			try {	props.store(fos,null);	}
			catch (IOException e) {
				System.out.println(e.toString());
				}
			}
		catch (Exception e) {
			System.out.println("Error while saving properties file >"+filename+"< "+e.toString());
			}
		System.out.println("Properties file >"+filename+"< saved.");
	}

	public String getProperty(String key) {
		return allProjects.getProperty(key,"key not found");	
	}


	private Project getProject(Properties p) {
		Project project = new Project();
		String projectName = p.getProperty("projectname");
		if (projectName!=null) {
			project.projectName = p.getProperty("projectname","not found");
			project.xletClass = p.getProperty("xletclass","not found");
			project.path = p.getProperty("path","not found");
			project.orgid = p.getProperty("orgid","0");
			project.appid = p.getProperty("appid","0");
			project.todo = new Boolean(p.getProperty("todo","true")).booleanValue();
			project.trace = new Boolean(p.getProperty("trace","true")).booleanValue();
			project.debug = new Boolean(p.getProperty("debug","true")).booleanValue();
			project.fixme = new Boolean(p.getProperty("fixme","true")).booleanValue();
			project.error = new Boolean(p.getProperty("error","true")).booleanValue();
			project.classloader = new Boolean(p.getProperty("classloader","true")).booleanValue();
			project.subtitles = new Boolean(p.getProperty("subtitles","false")).booleanValue();
						
		} else {
			return null;
		}
		//System.out.println(">>>> "+project.projectName+" >>>>>");
		return project;
	}


	public void addProject(Project p) {
		Properties props = new Properties();
		props.put("projectname",p.getProjectName());
		props.put("xletclass",p.getXletClass());
		props.put("path",p.getPath());
		props.put("orgid",p.getOrgId());
		props.put("appid",p.getAppId());
		props.put("todo",new Boolean(p.todo).toString());
		props.put("trace",new Boolean(p.trace).toString());
		props.put("fixme",new Boolean(p.fixme).toString());
		props.put("error",new Boolean(p.error).toString());
		props.put("debug",new Boolean(p.debug).toString());
		props.put("classloader",new Boolean(p.classloader).toString());
		props.put("subtitles",new Boolean(p.subtitles).toString());		
		saveProperties(currentPath+File.separator+p.getProjectName().replace(' ','_'),props);
	}

	/** Delete project file from file system. */
	public boolean deleteProject(Project project) {
		File toBeDeleted = new File(project.projectFile);
		if (toBeDeleted.exists()) {
			boolean deleted = toBeDeleted.delete();	
			if (deleted) {
				Out.printMe(Out.TRACE,"Project "+project.projectFile+" deleted.");
				return true;
			}
			else {
				Out.printMe(Out.ERROR,"Project "+project.projectFile+" could not be deleted. Use should delete it by hand, or fix the code...");
				return false;
			}
		}
		else {
			Out.printMe(Out.ERROR,"Project to be deleted could not be found.");
			return false;
		}
	}

}
