package org.openmhp.system;

import org.openmhp.xlet.*;
import javax.tv.xlet.*;
import java.net.*;
import org.openmhp.application.*;
import org.dvb.application.*;
import java.io.*;
import java.util.*;

import org.openmhp.adaptation.event.*;

import org.openmhp.util.Out;

/**
* Xlet launcher
*/
public class XletManager {

	Class loadedClass;
	Xlet xlet;
	XletContextImpl context;
	XletLoader xletLoader;
	AppID appid;

	static ObjectOutputStream ous;
	static ObjectInputStream ois;

	public XletManager(URL path,String xletclass, int oid, int aid) {

	   	String s1 = (new File("")).getAbsolutePath();
		URL url = null;
		try { url = new URL("file:\\\\\\"+s1+"/"); }
		catch (Exception e) { Out.printMe(Out.ERROR,e.toString()); }

   		appid = new AppID(oid,aid);


		org.openmhp.system.ProjectHandler handler = new org.openmhp.system.ProjectHandler(org.openmhp.system.Constants.ROOT+File.separator+org.openmhp.system.Constants.PROJECT_DIR);
   	    Project[] projectArray = handler.getProjects();


		boolean classloader = true;
		Project thisProject = null;

		for (int i=0;i<projectArray.length;i++) {
			if (new Integer(projectArray[i].orgid).intValue()==appid.getOID()) {
				if (new Integer(projectArray[i].appid).intValue()==appid.getAID()) {
					thisProject = projectArray[i];
					classloader = thisProject.classloader;
					Out.setTrace(thisProject.trace);
					Out.setDebug(thisProject.debug);
					Out.setFixme(thisProject.fixme);
					Out.setTodo(thisProject.todo);
					Out.setError(thisProject.error);
					SubtitleLayer.getInstance().setSubtitles(thisProject.subtitles);
				}
			}
		}

        XletLoader xl = new XletLoader(new URL[] { url });
        xl.setOutput(classloader);
        loadedClass = xl.loadClass(xletclass);

		//Socket s = openXletConnection();
		//new XletReceiver();

        initXlet();
        startXlet();
	}

	/**
	Method starts loading xlet
	@author tejopa
	@version 18.1.2002
	*/
	 void loadXlet(URL path, String xletName) {
		xletLoader = new XletLoader(new URL[]{ path });

		try		{
			loadedClass = xletLoader.loadClass(xletName);
            xlet = (Xlet)loadedClass.newInstance();
		}
		catch (Exception e)		{
			Out.printMe(Out.ERROR,e.toString());
		}
	}


	/**
	Method calls current xlet's initXlet() method
	@author tejopa
	@version 18.1.2002
	*/
	 void initXlet() {
		context = new XletContextImpl(this,xlet);
		//context.setRun(this);
		try	{
//			loadedClass = xletLoader.loadClass(xletName);
            xlet = (Xlet)loadedClass.newInstance();
			xlet.initXlet(context);
		}
		catch(Exception e) {
			System.out.println("initxlet: "+e.toString());
            e.printStackTrace();
			return;
        }
	}



	/**
	Method calls current xlet's startXlet() method
	@author tejopa
	@version 18.1.2002
	*/
	 void startXlet()	{
		try	{
			xlet.startXlet();
		}
		catch(Exception e) {
			Out.printMe(Out.ERROR,"startxlet: "+e.toString());
			return;
        }
        //Out.printMe(Out.TRACE,"startin event listener");
		//new EventHandler("127.0.0.1",51235);
	}


	/**
	Method calls current xlet's destoryXlet() method
	@author tejopa
	@version 18.1.2002
	*/
	 void killXlet()	{
		try	{
				System.out.println("Emulator says: I have started killing xlet.");
			//	remote.removeKeyListener((KeyListener)xlet);
				xlet.destroyXlet(false);
				xlet=null;
				System.out.println("Emulator says: I have killed xlet.");
		}
		catch(Exception e) {
			System.out.println(e.toString());
			return;
        }
	}

	/**
	Method loads class named "name"
	@author tejopa
	@version 18.1.2002	*/
    private Class loadClass(String name) {
        try {
            return Class.forName(name);
        }
        catch(Exception e) {
            System.out.println(e.toString());
        	return null;
        }
    }

	public AppID getAppID() { return appid; }


	private static Socket openXletConnection() {
		Out.printMe(Out.TRACE);
		//Out.println(new Object(),"AppsDatabaseImpl loadRemoteDatabase trying to load remote database");
		ADBRequest request = new ADBRequest(ADBRequest.XLET_CONNECTION,null);
		ADBRequest response = null;
		Socket s = null;
		try {
			Out.println(new Object(),"TRYING CONNECT TO:"+"localhost:"+AppsDatabaseServer.SERVER_PORT);
			s = new Socket("localhost",AppsDatabaseServer.SERVER_PORT);
			ous = new ObjectOutputStream(s.getOutputStream());
			ois = new ObjectInputStream(s.getInputStream());
			ous.writeObject(request);
			ous.flush();
			Out.printMe(Out.TRACE,"Xletconnection open.");
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"Could not open xletconnection");
		}
		return s;
	}


	public static void requestDestroy(AppID appid) {
		Out.printMe(Out.TRACE);
		//Out.println(new Object(),"AppsDatabaseImpl loadRemoteDatabase trying to load remote database");
		ADBRequest request = new ADBRequest(ADBRequest.XLET_DESTROY,appid);
		ADBRequest response = null;
		Socket s = null;
		try {
			Out.println(new Object(),"TRYING CONNECT TO:"+"localhost:"+AppsDatabaseServer.SERVER_PORT);
			s = new Socket("localhost",AppsDatabaseServer.SERVER_PORT);
			ObjectOutputStream ous = new ObjectOutputStream(s.getOutputStream());
			ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
			ous.writeObject(request);
			ous.flush();
			ous.close();
			s.close();
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"Could not open xletconnection "+e.toString());
		}
	}

	public static void requestPause(AppID appid) {
		Out.printMe(Out.TRACE);
		//Out.println(new Object(),"AppsDatabaseImpl loadRemoteDatabase trying to load remote database");
		ADBRequest request = new ADBRequest(ADBRequest.XLET_PAUSE,appid);
		ADBRequest response = null;
		Socket s = null;
		try {
			Out.println(new Object(),"TRYING CONNECT TO:"+"localhost:"+AppsDatabaseServer.SERVER_PORT);
			s = new Socket("localhost",AppsDatabaseServer.SERVER_PORT);
			ObjectOutputStream ous = new ObjectOutputStream(s.getOutputStream());
			ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
			ous.writeObject(request);
			ous.flush();
			ous.close();
			s.close();
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"Could not open xletconnection "+e.toString());
		}
	}

	public static void requestInit(AppID appid) {
		Out.printMe(Out.TRACE);
		//Out.println(new Object(),"AppsDatabaseImpl loadRemoteDatabase trying to load remote database");
		ADBRequest request = new ADBRequest(ADBRequest.XLET_INIT,appid);
		ADBRequest response = null;
		Socket s = null;
		try {
			Out.println(new Object(),"TRYING CONNECT TO:"+"localhost:"+AppsDatabaseServer.SERVER_PORT);
			s = new Socket("localhost",AppsDatabaseServer.SERVER_PORT);
			ObjectOutputStream ous = new ObjectOutputStream(s.getOutputStream());
			ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
			ous.writeObject(request);
			ous.flush();
			ous.close();
			s.close();
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"Could not open xletconnection "+e.toString());
		}
	}

	public static void requestStart(AppID appid) {
		Out.printMe(Out.TRACE);
		//Out.println(new Object(),"AppsDatabaseImpl loadRemoteDatabase trying to load remote database");
		ADBRequest request = new ADBRequest(ADBRequest.XLET_START,appid);
		ADBRequest response = null;
		Socket s = null;
		try {
			Out.println(new Object(),"TRYING CONNECT TO:"+"localhost:"+AppsDatabaseServer.SERVER_PORT);
			s = new Socket("localhost",AppsDatabaseServer.SERVER_PORT);
			ObjectOutputStream ous = new ObjectOutputStream(s.getOutputStream());
			ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
			ous.writeObject(request);
			ous.flush();
			ous.close();
			s.close();
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"Could not open xletconnection "+e.toString());
		}
	}











	class XletReceiver implements Runnable {
		public XletReceiver() {
			new Thread(this).start();
		}
		public void run() {
			while (true) {
				try {
					Object o = ois.readObject();
					Thread.currentThread().sleep(1000);
					Out.printMe(Out.TRACE,"Object received");
				}
				catch (Exception e) {
					Out.printMe(Out.ERROR,e.toString());
				}
			}
		}
	}


}