package org.openmhp.util;

import java.awt.*;
import org.dvb.ui.*;
/**
* @author tejopa
* @date 22.6.2004
* TODO Do minimum alpha colors
*/
public class MHPPaletteUtil {

	int[] reds = new int[]{ 0,63,127,191,255 };
	int[] greens = new int[]{ 0,31,63,95,127,159,191,223,255 };
	int[] blues = new int[]{ 0, 127, 255 };
	int[] alphas = new int[]{ 0, 179, 255 };
	int[] greys = new int[]{ 0, 42,85, 127, 170, 212, 255 };

	int[] redarray = new int[256];
	int[] greenarray = new int[256];
	int[] bluearray = new int[256];
	int[] greyarray = new int[256];
	int[] alphaarray = new int[256];

	private static MHPPaletteUtil instance;

	protected MHPPaletteUtil() {
		// create palette for lookups
		redarray = calc(redarray,reds);
		greenarray = calc(greenarray,greens);
		bluearray = calc(bluearray,blues);
		greyarray = calc(greyarray,greys);
		alphaarray = calc(alphaarray,alphas);
		/*
		for (int i=0;i<greyarray.length;i++) {
			System.out.println(greyarray[i]);
		}
		*/
	}

	private int[] calc(int[] target, int[] values) {
		int r1 = 0;
		int r2 = 1;
		int i=0;
		int first = 0;
		int last = 0;
		int middle = 0;
		while (r2<values.length) {
			first = values[r1];
			last = values[r2];
			middle = first+(last-first)/2;
			for (int a=first;a<=middle;a++) {
				target[a] = first;
			}
			for (int a=middle;a<=last;a++) {
				target[a] = last;
			}
			r1++;
			r2++;
		}
		return target;
	}

	public static MHPPaletteUtil getInstance() {
		if (instance==null) {
			instance = new MHPPaletteUtil();
		}
		return instance;
	}

	public Color getMatch(Color c) {
		int red = c.getRed();
		int green = c.getGreen();
		int blue = c.getBlue();
		int alpha = c.getAlpha();
		// RETURN CLOSEST GREY
		if ((red==green)&(green==blue)) {
			return new Color(greyarray[red],greyarray[green],greyarray[blue],alphaarray[alpha]);
		}
		// RETURN CLOSEST FROM PALETTE
		return new Color(redarray[red],greenarray[green],bluearray[blue],alphaarray[alpha]);
	}

	public void printColor(int r, int g, int b, String name) {
		System.out.println(r+" "+g+" "+b+" "+name);
	}

	/**
	Could do better with Hashtable...
	*/
	public boolean isMHPColor(Color c) {
		boolean result = false;
		int r = c.getRed();
		int g = c.getGreen();
		int b = c.getBlue();
		if ((r==g)&&(g==b)) {
			if (contains(r,greys)!=-1) { return true; }
		}
		if (contains(r,reds)==-1) { return false; }
		if (contains(g,greens)==-1) { return false; }
		if (contains(b,blues)==-1) { return false; }
		return true;
	}

	/* Checks if item is in array. Return -1 if not found, otherwise returns
	* index first occurrence of item.
	*/
	private int contains(int item, int[] array) {
		int result = -1;
		for (int i=0;i<array.length;i++) {
			if (array[i]==item) {
				result = i;
				i=array.length; // ends loop
			}
		}
		return result;
	}

}