
package org.dvb.application.storage;

import org.dvb.application.AppProxy;
import org.dvb.application.AppID;

/** 
  * Defines the information about a stored application service.
  * <p>
  * Stored application services can be created by applications
  * that have a permission to store applications for an 
  * organisation_id.
  * <p>
  * Stored application services are uniquely identified within 
  * the terminal by the combination of the organisation_id
  * and service_id. 
  *
  * @since MHP1.1
  */

public interface StoredApplicationService extends javax.tv.service.Service,
                                          ApplicationStorage {

    /** 
      * The service information is from storage
      */  
    public static final javax.tv.service.ServiceInformationType STORED = null;

    /** 
      * The service type for a stored application
      * @see javax.tv.service.navigation.ServiceTypeFilter
      */
    public static final javax.tv.service.ServiceType STORED_APPLICATION_SERVICE = null; //new StoredServiceType("Stored service");

    /** 
      * Return the organisation id of this stored application service
      *
      * @return the organisation id of this stored application service
      */
    public int getOrganisationId();

    /** 
      * Return the service id of this stored application service
      *
      * @return the service id of this stored application service
      */
    public int getServiceId();

    /**
      * Gets the Locator for this stored application service. This locator 
      * is opaque and platform specific. It is not required to be 
      * an instance of any public locator class in the platform.
      *
      * @return a locator for this stored application service
      */
    public javax.tv.locator.Locator getLocator();

    /** 
      * Returns the name of the stored application service as defined 
      * when the stored application service was created.
      *
      * @return the name of the stored application service
      */
    public java.lang.String getName();

    /**
      * Returns the service information format of this object. 
      * This shall always return STORED.
      *
      * @return the service information format
      */
    public javax.tv.service.ServiceInformationType getServiceInformationType();


    /**
      * Returns the type of this service. For stored application 
      * services, this method shall always return
      * STORED_APPLICATION_SERVICE.
      *
      * @return service type of this service
      */
    public javax.tv.service.ServiceType getServiceType();

    /**
      * Indicates whether the service represented by this 
      * Service is available on multiple transports. For stored
      * application services, this shall always return false.
      *
      * @return false
      */
    public boolean hasMultipleInstances();

    /**
      * Request the removal of the whole stored application service 
      * from the terminal. Removal of the service results in the
      * removal of all the applications from within that service.
      *
      * @throw SecurityException if the caller does not have an instance of
      * ApplicationStoragePermission with action either "remove_service" or "*"
      * and an organisation_id which matches that of this service.
      */
    public void removeService();

    /** 
      * This method retrieves additional information about the service. 
      * This shall result in failure with the SIRequestFailureType
      * DATA_UNAVAILABLE.
      *
      * @param requestor The SIRequestor to be notified when this 
      *                  operation completes.
      * @return A SIRequest object identifying this request.
      */
    public javax.tv.service.SIRequest retrieveDetails(
						      javax.tv.service.SIRequestor requestor);

//    private class StoredServiceType extends javax.tv.service.ServiceType {
//	
//	private StoredServiceType(String s) {
//	    super(s);
//	}
//    }
}

