package org.davic.mpeg.sections;

import org.openmhp.util.*;

/**
* @author tejopa
* @date 7.3.2004
* @date 14.11.2004 implementation, docs
* @status not implemented
* @module internal
* @HOME
*/
public abstract class SectionFilter{

	LinkedList listeners;
	int pid = 0;
	Object applicationData;
	int tableId = 0;
	byte[] posFilterDef;
	byte[] posFilterMask;
	int offset = 0;
	byte[] negFilterDef;
	byte[] negFilterMask;

	boolean filtering = false;
	long timeOut = 0;

	SectionFilter()	{
		Out.printMe(Out.TRACE);
		listeners = new LinkedList();
	}

	public void addSectionFilterListener(SectionFilterListener listener){
		Out.printMe(Out.TRACE);
		listeners.add(listener);
	}

	public void removeSectionFilterListener(SectionFilterListener listener){
		Out.printMe(Out.TRACE);
		listeners.remove(listener);
	}

	/** TODO EXCEPTIONS*/
	public void startFiltering(Object appData, int pid) throws FilterResourceException, org.davic.mpeg.NotAuthorizedException,  IllegalFilterDefinitionException,	ConnectionLostException	{
		Out.printMe(Out.TODO);
		applicationData = appData;
		this.pid = pid;
	}

	/** TODO EXCEPTIONS*/
	public void startFiltering(Object appData, int pid, int table_id) throws FilterResourceException, org.davic.mpeg.NotAuthorizedException, ConnectionLostException, IllegalFilterDefinitionException{
		Out.printMe(Out.TODO);
		startFiltering(appData,pid);
		tableId = table_id;
	}

	/** TODO EXCEPTIONS*/
	public void startFiltering(Object appData, int pid, int table_id, byte posFilterDef[], byte posFilterMask[]) throws FilterResourceException, IllegalFilterDefinitionException, org.davic.mpeg.NotAuthorizedException, ConnectionLostException{
		Out.printMe(Out.TODO);
		startFiltering(appData,pid,table_id);
		this.posFilterDef = posFilterDef;
		this.posFilterMask = posFilterMask;
	}

	/** TODO EXCEPTIONS*/
	public void startFiltering(Object appData, int pid, int table_id, int offset, byte posFilterDef[], byte posFilterMask[]) throws FilterResourceException, IllegalFilterDefinitionException, org.davic.mpeg.NotAuthorizedException, ConnectionLostException{
		Out.printMe(Out.TODO);
		startFiltering(appData,pid,table_id,posFilterDef,posFilterMask);
		this.offset = offset;
	}

	/** TODO EXCEPTIONS*/
	public void startFiltering(Object appData, int pid, int table_id, byte posFilterDef[], byte posFilterMask[], byte negFilterDef[], byte negFilterMask[]) throws FilterResourceException, IllegalFilterDefinitionException, org.davic.mpeg.NotAuthorizedException, ConnectionLostException{
		Out.printMe(Out.TODO);
		startFiltering(appData,pid,table_id,posFilterDef,posFilterMask);
		this.negFilterDef = negFilterDef;
		this.negFilterMask = negFilterMask;
	}

	/** TODO EXCEPTIONS*/
	public void startFiltering(Object appData, int pid, int table_id, int offset, byte posFilterDef[], byte posFilterMask[], byte negFilterDef[], byte negFilterMask[]) throws FilterResourceException, IllegalFilterDefinitionException, org.davic.mpeg.NotAuthorizedException, ConnectionLostException{
		Out.printMe(Out.TODO);
		startFiltering(appData,pid,table_id,posFilterDef,posFilterMask,negFilterDef,negFilterMask);
		this.offset = offset;
	}

	/**
	If the parent SectionFilterGroup is attached to a TransportStream then filtering for sections matching this SectionFilter object will stop. If the parent is not attached then should it become attached, filtering for sections matching this SectionFilter object will not start.
	*/
	public void stopFiltering(){
		Out.printMe(Out.TRACE);
		filtering = false;
	}

	/**
    Sets the time-out for this section filter. When the time-out happens, a TimeOutEvent will be generated and sent to the SectionFilter object and filtering stops. For a SimpleSectionFilter this will be generated if no sections arrive within the specified period. For a TableSectionFilter, this will be generated if the complete table does not arrive within the specified time. For a RingSectionFilter, this will be generated if the specified time has elapsed since the arrival of the last section being successfully filtered. Setting a time-out of 0 milliseconds has the effect of removing a possible time-out. A set time-out only applies to subsequent filter activations, not to a possible filter activation that is currently in progress when the call to this method is made. The default time-out value is 0.

    Parameters:
        milliseconds - the time out period
    Throws:
        java.lang.IllegalArgumentException - if the 'milliseconds' parameter is negative
	*/
	public void setTimeOut(long milliseconds) throws IllegalArgumentException{
		Out.printMe(Out.TRACE);
		timeOut = milliseconds;
	}



}
