package org.dvb.event;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

import org.davic.resources.*;
import org.havi.ui.HScene;

import java.awt.*;
import java.awt.KeyboardFocusManager;
import java.awt.event.*;


import java.beans.*;

import org.openmhp.util.*;

/**
* @author tejopa
* @date 12.2.2004
* @status partially implemented
* @module internal, user interaction
* @TODO This implementation is NOT SINGLETON check specs
*/
public class EventManager implements ResourceServer {

    private static LinkedList userEventListeners;
    private static LinkedList userRepositorys;
    private static LinkedList userClients;

    private static LinkedList awtClients;
    private static LinkedList awtRepositorys;
    private static LinkedList resourceStatusListeners;
    private static FocusChangeListener fc;
    private static EventManager instance;


	/** tejopa 4.3.2004 */
    protected EventManager()    {

		fc = new FocusChangeListener();
 		KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(fc);

		awtClients = new LinkedList();
		awtRepositorys = new LinkedList();
		resourceStatusListeners = new LinkedList();

		userEventListeners = new LinkedList();
		userRepositorys = new LinkedList();
		userClients = new LinkedList();

    }

   	/** tejopa 4.3.2004 */
    public static EventManager getInstance()    {
        if(instance == null) {
            instance = new EventManager();
        }
        return instance;
    }

	/** tejopa 4.3.2004 */
    public boolean addExclusiveAccessToAWTEvent(ResourceClient client, UserEventRepository userEvents) throws IllegalArgumentException {
        if( client == null) {
            throw new IllegalArgumentException("ResourceClient given to addExclusiveAccessToAWTEvent was null");
        }
        else {
            awtClients.add(client);
            awtRepositorys.add(userEvents);
            /** TODO */
            fireResourceStatusEvent();
            return true;
        }
    }

	/** tejopa 4.3.2004 */
    public void addResourceStatusEventListener(ResourceStatusListener listener) {
        if (!resourceStatusListeners.has(listener))
            resourceStatusListeners.add(listener);
    }


	/** tejopa 4.3.2004 */
    public boolean addUserEventListener(UserEventListener listener, ResourceClient client, UserEventRepository userEvents) throws IllegalArgumentException    {
        Out.printMe(Out.TRACE,listener.toString());
        if(client == null) {
            throw new IllegalArgumentException("ResourceClient given to addUserEventListener was null");
        }
        else {
            userEventListeners.add(listener);
            userClients.add(client);
            userRepositorys.add(userEvents);
            fireResourceStatusEvent();
			Out.printMe(Out.TRACE,"#####################");

            return true;
        }
    }

	/** tejopa 4.3.2004 */
    public void addUserEventListener(UserEventListener listener, UserEventRepository userEvents) {
		Out.printMe(Out.TRACE,"#####################");
		userEventListeners.add(listener);
		userClients.add(new Object());
		userRepositorys.add(userEvents);
    }


	/** tejopa 4.3.2004 */
    public void removeExclusiveAccessToAWTEvent(ResourceClient client) {
		int i = awtClients.indexOf(client);
		if (i!=-1) {
			awtClients.remove(client);
			awtRepositorys.remove(awtRepositorys.get(i));
			fireResourceStatusEvent();
		}
	}

	/** tejopa 4.3.2004 */
    public void removeResourceStatusEventListener(ResourceStatusListener listener) {
        if (resourceStatusListeners!=null) {
	        resourceStatusListeners.remove(listener);
    	}
    }



    public void removeUserEventListener(UserEventListener listener) {
		int i = userEventListeners.indexOf(listener);
		if (i!=-1) {
			userEventListeners.remove(listener);
			userClients.remove(userClients.get(i));
			userRepositorys.remove(userRepositorys.get(i));
		}
    }

	// private

    private void fireResourceStatusEvent() {
    	for(int i = 0; i < resourceStatusListeners.size(); i++) {
            ResourceStatusListener resourcestatuslistener = (ResourceStatusListener)resourceStatusListeners.get(i);
            resourcestatuslistener.statusChanged(new ResourceStatusEvent(this));
        }

    }

	public static Component focusedComponent = null;

    public void fireUserEvent(Object obj, KeyEvent keyevent)    {
		Out.printMe(Out.TRACE,obj.toString()+" "+keyevent);
		Out.printMe(Out.TRACE,"FOCUSED COMPONENT: "+focusedComponent.toString());

		if (focusedComponent!=null) {
           // do not send events back to originating source -> infinite loop
           if (focusedComponent!=keyevent.getSource()) {

	            KeyListener[] akeylistener = focusedComponent.getKeyListeners();
    	        for(int j1 = 0; j1 < akeylistener.length; j1++) {
                   	akeylistener[j1].keyPressed(keyevent);
            	}
			}
		}
		else {
			System.out.println("## no component to receive events");
		}

		int keyCode = keyevent.getKeyCode();

        for(int i=0;i<userEventListeners.size(); i++) {
            UserEventListener currentListener = (UserEventListener)userEventListeners.get(i);

            UserEvent[] userevents = ((UserEventRepository)userRepositorys.get(i)).getUserEvent();

            for (int j=0;j<userevents.length;j++) {
            	if(userevents[j].getCode() == keyCode) {
                    UserEvent userevent = new UserEvent(obj, 1, 401, keyCode, -1);
                    System.out.println("#### "+currentListener.toString()+" "+userevent.toString());
                	currentListener.userEventReceived(userevent);
                }
            }
        }

    }



     class FocusChangeListener implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Component oldComp = (Component)evt.getOldValue();
            Component newComp = (Component)evt.getNewValue();

            if ("focusOwner".equals(evt.getPropertyName())) {
                if (oldComp == null) {
                	focusedComponent = newComp;

                } else {
                   // System.out.println("focusedComponent is :"+focusedComponent);
                }
            } else if ("focusedWindow".equals(evt.getPropertyName())) {
                if (oldComp == null) {

                } else {

                }
            }
        }

    }


}