package org.dvb.net.rc;

/**
* @author tejopa
* @date 7.3.2004
* @date 29.11.2004 docs
* @status partially implemented
* @module internal
* @HOME

Description
This class is for return channel set-up permissions. An RCPermission contains a name, but no actions
list.
The permission name can be "target:default", which indicates the permission to use the default
connection parameters.
The permission name can also be "target:<phone number>", which indicates the permission to use the
speci.ed phone number in the connection set-up
(ConnectionRCInterface.setTarget(ConnectionParameters) method).
A wildcard may be used at the end of the permission name. In that case, all phone numbers starting with
the number before the wildcard are included in the permission.
Examples:
 target:0206234342 (Permission to dial the specified phone number)
 target:020* (Permission to dial phone numbers starting with 020)
 target:* (Permission to dial all phone numbers, including the default)
Note: ConnectionRCInterface.reserve(ResourceClient, Object) will throw a SecurityException if the
application is not allowed to set-up a connection over the return channel at all (i.e., there is no valid
target allowed).

*/
public class RCPermission extends java.security.BasicPermission{

	/**
	Creates a new RCPermission with the speci.ed name. The name is the symbolic name of the
	RCPermission.
	Parameters:
	name - the name of the RCPermission
	*/
	public RCPermission(String name){
		super(name);
	}

	/**
	Creates a new RCPermission object with the speci.ed name. The name is the symbolic name of the
	RCPermission, and the actions String is unused and should be null. This constructor exists for use by
	the Policy object to instantiate new Permission objects.
	Parameters:
	name - the name of the RCPermission
	actions - should be null.
	*/
	public RCPermission(String name, String actions){
		super(name,actions);
	}

}
