package org.dvb.si;

/**
* @author tejopa
* @date 7.3.2004
* @date 29.11.2004 partial implementation, docs
* @status partially implemented
* @module internal
* @HOME

This class represents a descriptor within a sub-table.
A descriptor consist of three fields: a tag, a contentLength and the content.
The tag uniquely identifies the descriptor type. The content length indicates the number of bytes in the
content. The content consists of an array of bytes of length content length. The data represented by the
content is descriptor type dependent.

*/
public class Descriptor{

	byte[] content;
	short tag;

  	Descriptor() {
  		content = new byte[0];
  		tag = 0;
  	}


	public short getTag() {
		return tag;
	}

	public short getContentLength() {
		return (short)content.length;
	}

	public byte getByteAt(int index) throws java.lang.IndexOutOfBoundsException {
		if (index<0) throw new IndexOutOfBoundsException();
		if (index>content.length) throw new IndexOutOfBoundsException();
		return content[index];
	}

	public byte[] getContent() {
		return content;
	}

}
