package org.dvb.ui;

import java.awt.Color;
import java.awt.Graphics;

/**
 * @author tejopa
 * @date 7.3.2004
 * @date 1.12.2004 docs
 * @status partially implemented
 * @module internal
 * @HOME
 */
public abstract class DVBGraphics extends Graphics {
    
    protected DVBGraphics() { }
    
    public abstract int[] getAvailableCompositeRules();
    
    /** done in implementation */
    public DVBColor getBestColorMatch(Color color) {
        return null;
    }
    
    public abstract Color getColor();
    
    public abstract DVBAlphaComposite getDVBComposite();
    
    /** done in implementation */
    public int getType() {
        return 0;
    }
    
    public abstract void setColor(Color color);
    
    public abstract void setDVBComposite(DVBAlphaComposite dvbalphacomposite) throws UnsupportedDrawingOperationException;
    
    public String toString() {
        return getClass().getName() + "font=" + getFont() + " color=" + getColor();
    }
    
}