package org.dvb.ui;

import org.openmhp.util.Out;

import java.io.IOException;

/**
* @author tejopa
* @date 7.3.2004
* @date 29.11.2004 docs
* @status not implemented
* @module internal
* @HOME
*/
public class FontFactory {

	/**
	Constructs a FontFactory for the font index file bound to this application in the application signaling.
	The call to the constructor is synchronous and shall block until the font index .le has been retrieved
	or an an exception is thrown.
	Throws:
	FontFormatException - if there is an error in the font index .le bound with the application.
	java.io.IOException - if there is no font index .le bound with the application, or if there is an
	error attempting to access the data in that .le.
	*/
	public FontFactory() throws FontFormatException, IOException {
		Out.printMe(Out.TODO,"Read fontindex file from the application dir");
	}

	/**
	Constructs a FontFactory for the specification of fonts found at the given location. The call to the
	constructor is synchronous and shall block until the font file has been retrieved or an exception is
	thrown.
	Parameters:
	u - The source of the font description
	Throws:
	java.io.IOException - if there is an error attempting to access the data referenced by the
	URL
	IllegalArgumentException - if the URL is not both valid and supported
	SecurityException - if access to the speci.ed URL is denied by security policy
	FontFormatException - if the .le at that URL is not a valid font .le as speci.ed in the main
	body of this speci.cation
	*/
	public FontFactory(java.net.URL u) throws IOException, FontFormatException {
		Out.printMe(Out.TODO,"Read fontindex file from the url");
    }

	/**
	Creates a font object from the font source associated with this FontFactory. This font will remain valid
	even if the FontFactory is no longer reachable from application code. The name returned by
	Font.getName() might not be the same as the name supplied, for example, it might have a string
	prepended to it that identi.es the source FontFactory in a platform-dependant manner. For
	FontFactory instances bound to the font index .le of an application, the call to the method is
	synchronous and shall block until either an exception is thrown or any required network access has
	completed.
	The value of the style argument must be as de.ned in java.awt.Font. Valid values are the following:
	 java.awt.Font.PLAIN
	 java.awt.Font.BOLD
	 java.awt.Font.ITALIC
	 java.awt.Font.BOLD + java.awt.Font.ITALIC
	Parameters:
	name - the font name
	style - the constant style used, such as java.awt.Font.PLAIN.
	size - the point size of the font
	Throws:
	FontNotAvailableException - if a font with given parameters cannot be located or created.
	java.io.IOException - if there is an error retrieving a font from the network. Thrown only for
	font factory instances bound to the font index .le of an application.
	IllegalArgumentException - if the style parameter is not in the set of valid values, or if the
	size parameter is zero or negative.
	FontFormatException - if the font .le is not a valid font .le as speci.ed in the main body of
	this speci.cation. Thrown only for font factory instances bound to the font index .le of an
	application.
	*/
	public java.awt.Font createFont(String name, int style, int size) throws FontNotAvailableException,FontFormatException, IOException {
		Out.printMe(Out.TODO,"Try to create specified font");
		return null;
    }

}
