package org.havi.ui;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 4.3.2004
* @status partially
* @module internal
*/
import org.havi.ui.event.*;

import java.awt.event.*;

import java.util.EventListener;

import org.davic.resources.ResourceStatusEvent;
import org.davic.resources.ResourceStatusListener;


public class HEventMulticaster implements HBackgroundImageListener, HScreenConfigurationListener, HScreenLocationModifiedListener,
 java.awt.event.WindowListener, HActionListener, HAdjustmentListener, HFocusListener, HItemListener,
HTextListener, HKeyListener, ResourceStatusListener {

    protected final EventListener a, b;

	/** tejopa 4.3.2004 */
    protected HEventMulticaster(EventListener a_a, EventListener a_b){
        a = a_a; b = a_b;
    }

	/** tejopa 4.3.2004 */
    public void actionPerformed(ActionEvent e) {
        ((ActionListener)a).actionPerformed(e);
        ((ActionListener)b).actionPerformed(e);
    }

	/** tejopa 4.3.2004 */
    public static HActionListener add(HActionListener a, HActionListener b){
        return (HActionListener)addInternal(a, b);
    }

	/** tejopa 4.3.2004 */
    public static HAdjustmentListener add(HAdjustmentListener a, HAdjustmentListener b){
        return (HAdjustmentListener)addInternal(a, b);
    }

	/** tejopa 4.3.2004 */
	public static HBackgroundImageListener add(HBackgroundImageListener a, HBackgroundImageListener b){
        return (HBackgroundImageListener)addInternal(a, b);
    }

	/** tejopa 4.3.2004 */
    public static HFocusListener add(HFocusListener a, HFocusListener b){
        return (HFocusListener)addInternal(a, b);
    }

	/** tejopa 4.3.2004 */
    public static HItemListener add(HItemListener a, HItemListener b){
        return (HItemListener)addInternal(a, b);
    }
    
    /** tejopa 4.3.2004 */
    public static HKeyListener add(HKeyListener a, HKeyListener b){
        return (HKeyListener)addInternal(a, b);
    }    
    
    /** tejopa 4.3.2004 */
    public static HScreenConfigurationListener add(HScreenConfigurationListener a, HScreenConfigurationListener b){
        return (HScreenConfigurationListener)addInternal(a, b);
    }

    /** tejopa 4.3.2004 */
    public static HScreenConfigurationListener add(HScreenConfigurationListener a, HScreenConfigurationListener b, HScreenConfigTemplate tb){
		Out.printMe(Out.TODO,"HScreenConfigTemplate IS NOT attached"); 
        return (HScreenConfigurationListener)addInternal(a, b);
    }

    /** tejopa 4.3.2004 */
	public static HScreenLocationModifiedListener add(HScreenLocationModifiedListener a, HScreenLocationModifiedListener b){
        return (HScreenLocationModifiedListener)addInternal(a, b);
    }
        
    /** tejopa 4.3.2004 */
     public static HTextListener add(HTextListener a, HTextListener b){
        return (HTextListener)addInternal(a, b);
    }

    /** tejopa 4.3.2004 */
    public static ResourceStatusListener add(ResourceStatusListener a, ResourceStatusListener b) {
        return (ResourceStatusListener)addInternal(a, b);
    }

    /** tejopa 4.3.2004 */
    public static WindowListener add(WindowListener a, WindowListener b){
        return (WindowListener)addInternal(a, b);
    }

	/** tejopa 4.3.2004 */
    protected static EventListener addInternal(EventListener a, EventListener b) {
        if (a == null) {
        	return b;
        }
        if (b == null) {
        	return a;
        }
        return new HEventMulticaster(a, b);
    }

	/** tejopa 4.3.2004 */
    public void caretMoved(HTextEvent e){
        ((HTextListener)a).caretMoved(e);
        ((HTextListener)b).caretMoved(e);
    }

	/** tejopa 4.3.2004 */
    public void currentItemChanged(HItemEvent e) {
        ((HItemListener)a).currentItemChanged(e);
        ((HItemListener)b).currentItemChanged(e);
    }

	/** tejopa 4.3.2004 */
	public void focusGained(FocusEvent e)  {
        ((FocusListener)a).focusGained(e);
        ((FocusListener)b).focusGained(e);
    }

	/** tejopa 4.3.2004 */
    public void focusLost(FocusEvent e){
        ((FocusListener)a).focusLost(e);
        ((FocusListener)b).focusLost(e);
    }

	/** tejopa 4.3.2004 */
    public void imageLoaded(HBackgroundImageEvent  e){
        ((HBackgroundImageListener)a).imageLoaded(e);
        ((HBackgroundImageListener)b).imageLoaded(e);
    }

	/** tejopa 4.3.2004 */
    public void imageLoadFailed(HBackgroundImageEvent  e){
        ((HBackgroundImageListener)a).imageLoadFailed(e);
        ((HBackgroundImageListener)b).imageLoadFailed(e);
    }

	/** tejopa 4.3.2004 */
    public void keyPressed(KeyEvent e){
        ((KeyListener)a).keyPressed(e);
        ((KeyListener)b).keyPressed(e);
    }
    
	/** tejopa 4.3.2004 */
    public void keyReleased(KeyEvent e){
        ((KeyListener)a).keyReleased(e);
        ((KeyListener)b).keyReleased(e);
    }

	/** tejopa 4.3.2004 */
    public void keyTyped(KeyEvent e){
        ((KeyListener)a).keyTyped(e);
        ((KeyListener)b).keyTyped(e);
    }

	/** tejopa 4.3.2004 */
    protected EventListener remove(EventListener oldl) {
        if (a == oldl) {
        	return b;
        }
        if (b == oldl) {
        	return a;
        }
        return this;
    }

	/** tejopa 4.3.2004 */
	public static HActionListener remove(HActionListener l, HActionListener oldl){
        return (HActionListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */
    public static HAdjustmentListener remove(HAdjustmentListener l, HAdjustmentListener oldl){
        return (HAdjustmentListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */
    public static HBackgroundImageListener remove(HBackgroundImageListener l, HBackgroundImageListener oldl) {
        return (HBackgroundImageListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */
    public static HFocusListener remove(HFocusListener l, HFocusListener oldl){
        return (HFocusListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */
    public static HItemListener remove(HItemListener l, HItemListener oldl){
        return (HItemListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */    
    public static HKeyListener remove(HKeyListener l, HKeyListener oldl){
        return (HKeyListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */    
    public static HScreenConfigurationListener remove(HScreenConfigurationListener l, HScreenConfigurationListener oldl){
        return (HScreenConfigurationListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */    
    public static HScreenLocationModifiedListener remove(HScreenLocationModifiedListener l, HScreenLocationModifiedListener oldl) {
        return (HScreenLocationModifiedListener)removeInternal(l, oldl);
    }
    
	/** tejopa 4.3.2004 */       
	public static HTextListener remove(HTextListener l, HTextListener oldl){
        return (HTextListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */   
    public static ResourceStatusListener remove(ResourceStatusListener l, ResourceStatusListener oldl){
        return (ResourceStatusListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */   
    public static WindowListener remove(WindowListener l, WindowListener oldl){
        return (WindowListener)removeInternal(l, oldl);
    }

	/** tejopa 4.3.2004 */
    protected static EventListener removeInternal(EventListener l, EventListener oldl) {
        if (l == oldl || l == null) {
            return null;
        } 
        else if (l instanceof HEventMulticaster) {
            return ((HEventMulticaster)l).remove(oldl);
        } 
        else {
            return l; 
        }
    }

	/** tejopa 4.3.2004 */
    public void report(HScreenConfigurationEvent  e){
        ((HScreenConfigurationListener)a).report(e);
        ((HScreenConfigurationListener)b).report(e);
    }
    
	/** tejopa 4.3.2004 */
    public void report(HScreenLocationModifiedEvent   e){
        ((HScreenLocationModifiedListener)a).report(e);
        ((HScreenLocationModifiedListener)b).report(e);
    }

	/** tejopa 4.3.2004 */
    public void selectionChanged(HItemEvent e){
        ((HItemListener)a).selectionChanged(e);
        ((HItemListener)b).selectionChanged(e);
    }

	/** tejopa 4.3.2004 */
    public void statusChanged(ResourceStatusEvent e) {
        ((ResourceStatusListener)a).statusChanged(e);
        ((ResourceStatusListener)b).statusChanged(e);
    }

	/** tejopa 4.3.2004 */
    public void textChanged(HTextEvent e){
        ((HTextListener)a).textChanged(e);
        ((HTextListener)b).textChanged(e);
    }

	/** tejopa 4.3.2004 */
    public void valueChanged(HAdjustmentEvent e){
        ((HAdjustmentListener)a).valueChanged(e);
        ((HAdjustmentListener)b).valueChanged(e);
    }

	/** tejopa 4.3.2004 */
    public void windowActivated(WindowEvent e) {
        ((WindowListener)a).windowActivated(e);
        ((WindowListener)b).windowActivated(e);
    }
    
	/** tejopa 4.3.2004 */    
	public void windowClosed(WindowEvent e) {
        ((WindowListener)a).windowClosed(e);
        ((WindowListener)b).windowClosed(e);
    }

	/** tejopa 4.3.2004 */    
    public void windowClosing(WindowEvent e) {
        ((WindowListener)a).windowClosing(e);
        ((WindowListener)b).windowClosing(e);
    }    

	/** tejopa 4.3.2004 */    
    public void windowDeactivated(WindowEvent e) {
        ((WindowListener)a).windowDeactivated(e);
        ((WindowListener)b).windowDeactivated(e);
    }

	/** tejopa 4.3.2004 */
    public void windowDeiconified(WindowEvent e) {
        ((WindowListener)a).windowDeiconified(e);
        ((WindowListener)b).windowDeiconified(e);
    }

	/** tejopa 4.3.2004 */
    public void windowIconified(WindowEvent e) {
        ((WindowListener)a).windowIconified(e);
        ((WindowListener)b).windowIconified(e);
    }

	/** tejopa 4.3.2004 */
    public void windowOpened(WindowEvent e) {
        ((WindowListener)a).windowOpened(e);
        ((WindowListener)b).windowOpened(e);
    }

}