package org.havi.ui;

import org.openmhp.util.LinkedList;
import org.openmhp.util.Out;

/**
* @author tejopa
* @date 6.3.2004
* @date 11.3.2004 (fixes)
* @status partially implemented
* @module internal, video, graphics
* HOME
*/
public class HScreen{

    private static final HScreen INSTANCE = new HScreen();

    private static LinkedList hScreens;

    private HVideoDevice currentHVideoDevice;
    private HGraphicsDevice currentHGraphicsDevice;
    private HBackgroundDevice currentHBackgroundDevice;
    
    
    private HVideoDevice hVideoDevices[];
    private HGraphicsDevice hGraphicsDevices[];
    private HBackgroundDevice hBackgroundDevices[];


    protected HScreen()    {
        currentHVideoDevice = new HVideoDevice();
        hVideoDevices = new HVideoDevice[1];
        hVideoDevices[0] = currentHVideoDevice;

        currentHGraphicsDevice = new HGraphicsDevice();
        hGraphicsDevices = new HGraphicsDevice[1];
        hGraphicsDevices[0] = currentHGraphicsDevice;

        currentHBackgroundDevice = new HBackgroundDevice();
        hBackgroundDevices = new HBackgroundDevice[1];
        hBackgroundDevices[0] = currentHBackgroundDevice;

        hScreens = new LinkedList();
        hScreens.add(this);
    }

   public HBackgroundConfiguration getBestConfiguration(HBackgroundConfigTemplate[] tmpl) {
		Out.printMe(Out.TODO,"do preference check");
        return currentHBackgroundDevice.getBestConfiguration(tmpl);
    }

    public HVideoConfiguration getBestConfiguration(HVideoConfigTemplate[] tmpl) {
		Out.printMe(Out.TODO,"do preference check");
        return currentHVideoDevice.getBestConfiguration(tmpl);
    }

    public HGraphicsConfiguration getBestConfiguration(HGraphicsConfigTemplate[] tmpl) {
		Out.printMe(Out.TODO,"do preference check");
		return currentHGraphicsDevice.getBestConfiguration(tmpl);
    }

    public HScreenConfiguration[] getCoherentScreenConfigurations(HScreenConfigTemplate ahscreenconfigtemplate[]) {
		Out.printMe(Out.TODO,"do preference check");
		return null;
    }

    public HBackgroundDevice getDefaultHBackgroundDevice()    {
		Out.printMe(Out.TRACE);    	
		return currentHBackgroundDevice;
    }

    public HGraphicsDevice getDefaultHGraphicsDevice()    {
		Out.printMe(Out.TRACE);
		return currentHGraphicsDevice;
    }

    public static HScreen getDefaultHScreen()    {
         return INSTANCE;
    }

    public HVideoDevice getDefaultHVideoDevice()    {
        return currentHVideoDevice;
    }

    public HBackgroundDevice[] getHBackgroundDevices()    {
        return hBackgroundDevices;
    }
    
    public HGraphicsDevice[] getHGraphicsDevices()    {
        return hGraphicsDevices;
    }    
    
    public static HScreen[] getHScreens()    {
        HScreen result[] = new HScreen[hScreens.size()];
        for(int i = 0; i < result.length; i++)
            result[i] = (HScreen)hScreens.get(i);
        return result;
    }


    public HVideoDevice[] getHVideoDevices()    {
        return hVideoDevices;
    }


    public boolean setCoherentScreenConfigurations(HScreenConfiguration ahscreenconfiguration[]) throws SecurityException, HPermissionDeniedException, HConfigurationException {
		Out.printMe(Out.TODO,"do preference check etc");
		return false;
    }

}