package org.havi.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;

import org.openmhp.util.*;

/**
* @author tejopa
* @date 11.3.2004 
* @status partially implemented
* @module internal
* TODO check default values
*/
public class HStaticText extends HVisible implements HNoInputPreferred{

    private HMatte currentMatte;
    private HTextLayoutManager textLayoutManager;
	private int paintMode = NO_BACKGROUND_FILL;
    private Dimension defaultSize = null;
    private int horizontalAlignment = HVisible.HALIGN_CENTER;
    private int verticalAlignment = HVisible.VALIGN_CENTER;
    private int scalingMode = HVisible.RESIZE_NONE;
    private static HTextLook defaultHLook = new HTextLook();
    
    //private HLook hLook = defaultHLook;

    public HStaticText(){
        super(defaultHLook, 0,0,0,0);
    }

    public HStaticText(String textNormal, int x, int y, int width, int height){
        super(defaultHLook, x, y, width, height);
        this.setTextContent(textNormal, HVisible.NORMAL_STATE);
        textLayoutManager = new HDefaultTextLayoutManager();
    }

    public HStaticText(String textNormal, int x, int y, int width, int height, Font font, Color foreground, Color background, HTextLayoutManager tlm){
            this(textNormal, x, y, width, height);
            this.textLayoutManager = tlm;
            this.setFont(font);
            this.setBackground(background);
            this.setForeground(foreground);
    }

    public HStaticText(String textNormal){
        this(textNormal, 0, 0, 0, 0);
    }

    public HStaticText(String textNormal, Font font, Color foreground, Color background, HTextLayoutManager tlm){
        this(textNormal, 0, 0, 0, 0, font, foreground, background, tlm);
    }

    public void setLook(HLook hLook) throws HInvalidLookException{
        this.hLook = hLook;
    }

    public static void setDefaultLook(HTextLook defaultHLook){
        HStaticText.defaultHLook = defaultHLook;
    }

    public static HTextLook getDefaultLook(){
        return defaultHLook;
    }
}
