package org.openmhp.adaptation.event;

import org.openmhp.application.AppsDatabaseImpl;
import java.net.*;
import java.io.*;
import java.awt.event.*;
import org.dvb.event.*;

import org.openmhp.util.Out;

public class EventHandler {

	Socket socket;
	ObjectOutputStream oos;

	public EventHandler(Socket s) {
		socket = s;
	}

	public void sendEvent(KeyEvent e) {
		if (oos==null) {
			try {
				oos = new ObjectOutputStream(socket.getOutputStream());	
			}
			catch (Exception ex) {
				Out.printMe(Out.ERROR,ex.toString());	
			}
		}
		else {
			try {
				oos.writeObject(e);
			}
			catch (Exception ex2) {
				Out.printMe(Out.ERROR,ex2.toString());	
			}
		}
			
	}

	public EventHandler(String ip, int port) {
		try {
			socket = new Socket(ip,port);
			startListening();
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,e.toString());	
		}
			
	}
	
	private void startListening() {
		ObjectInputStream ois = null;
		try {
			ois = new ObjectInputStream(socket.getInputStream());
			
			while (true) {
				Object o = ois.readObject();	
				System.out.println(o.toString());
				EventManager.getInstance().fireUserEvent(this,(KeyEvent)o);
	
			}
		}
		catch (Exception e) {
			System.out.println("eventhandler "+e);	
		}
	}

	
}