package org.openmhp.adaptation.graphics;

import java.io.*;
import java.net.*;
import org.openmhp.util.*;
import java.util.*;

public class GraphicsOutput implements Runnable {

	int port = 0;
	boolean stopRequested = false;
	boolean empty = true;
	Vector graphicsListeners;
	
	Object outputObject;

	public GraphicsOutput() { 
		//new GraphicsOutput(50000);
	}
	
	public GraphicsOutput(int port) {
		super();
		this.port = port;
		graphicsListeners = new Vector();
		new Thread(this).start();
	}

	public void addGraphicsListener(GraphicsListener gl){
		graphicsListeners.add(gl);	
	}

	public void removeGraphicsListener(GraphicsListener gl){
		graphicsListeners.remove(gl);	
	}


	private void stop() {
		stopRequested = true;
	}

	public void run() {
		ServerSocket s = null;
		try { 
			s = new ServerSocket(port);
			Out.printMe(Out.TRACE,"GraphicsOutput server started in port ("+port+")");
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"1: "+e.toString());
		}
		try {
			while (!stopRequested) {
				new GraphicsPipe(s.accept(),this); 		
			}
		}
		catch (Exception e2) {
			Out.printMe(Out.ERROR,"2: "+e2.toString());
		}
	}
/*
	public synchronized Object getOutputObject() {
		if (!empty) {
			empty = true;
			return outputObject;
		}
		else {
			return null;	
		}
	}

	public synchronized void setOutputObject(Object o) {
			outputObject = o;
			empty = false;
	}
*/

	public void setOutputObject(Object o) {
		Enumeration e = graphicsListeners.elements();
		while (e.hasMoreElements()) {
			GraphicsListener l = (GraphicsListener)e.nextElement();
			l.graphicsObjectReceived((Object)o);
		}
	}


}