package org.openmhp.appman;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;
import javax.swing.table.*;


import org.openmhp.system.*;
import org.openmhp.util.*;



/**
 * @date 28.1.2005 tejopa
 */
public class ProjectData implements TableModel {
    
    String[] columnNames;
    Vector tableModelListeners;
    
    Vector columns;
    Vector rows;
    
    public ProjectData(String[] colnames) {
        columnNames = colnames;
        tableModelListeners = new Vector();
        rows = new Vector();
    }
    
    public void addTableModelListener(TableModelListener l) {
        tableModelListeners.add(l);
    }
    
    public Class getColumnClass(int columnIndex) {
        try {
            return Class.forName("java.lang.String");
        } catch (Exception e) {
            Out.printMe(Out.ERROR,e.toString());
            return null;
        }
    }
    
    public int getColumnCount() {
        return columnNames.length;
    }
    
    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }
    
    public int getRowCount() {
        return rows.size();
    }
    
    public Object getValueAt(int rowIndex, int columnIndex) {
        return ((Vector)rows.elementAt(rowIndex)).elementAt(columnIndex);
    }
    
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
    
    public void removeTableModelListener(TableModelListener l) {
        tableModelListeners.remove(l);
    }
    
    public void setValueAt(Object aValue, int rowIndex, int columnIndex)  {
        
    }
    
    public void addRow(Vector r) {
        rows.add(r);
    }
    
    public void removeRows() {
        rows = new Vector();
    }
    
}


