package org.openmhp.si;

import org.dvb.si.*;

import java.util.Date;
import org.davic.net.dvb.*;
import javax.tv.service.navigation.*;

import 	org.davic.net.tuning.*;

import org.openmhp.util.Out;

import java.util.*;

/**
* @author tejopa
* @date 11.11.2003
* @status partially implemented
* @module internal, si
*/
public class SIDatabaseImpl extends org.dvb.si.SIDatabase {

	NetworkInterface networkInterface;

	public static SIDatabaseImpl[] databases;

	private RequestHandler requestHandler;
	
    protected SIDatabaseImpl()    {    			
    	requestHandler = new RequestHandler();
    	networkInterface = NetworkInterfaceManager.getInstance().getNetworkInterfaces()[0];
    }

    public static SIDatabaseImpl[] getSIDatabaseImpl()    {
        if (databases==null) {
			databases = new SIDatabaseImpl[1];
			databases[0] = new SIDatabaseImpl();
		}
        
        return databases;
    }

	public NetworkInterface getNetworkInterface() {
		return networkInterface;
	}

    public org.dvb.si.SIRequest retrieveSIBouquets(short word0, Object obj, SIRetrievalListener siretrievallistener, int i, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveSIBouquets");        
        return sir;
    }

    public org.dvb.si.SIRequest retrieveActualSINetwork(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveActualSINetwork");      
        return sir;
    }

    public org.dvb.si.SIRequest retrieveSINetworks(short word0, Object obj, SIRetrievalListener siretrievallistener, int i, short aword0[]) throws SIIllegalArgumentException    {
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveSINetworks");
        return sir;        
    }

    public org.dvb.si.SIRequest retrieveActualSITransportStream(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveActualSITransportStream");            
        return sir;
    }

    public org.dvb.si.SIRequest retrieveActualSIServices(short word, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO,word+" "+obj.toString());
    	SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveActualSIServices");
        return sir;        
    }

    public org.dvb.si.SIRequest retrieveSIServices(short word0, Object obj, SIRetrievalListener siretrievallistener, int i, int j, int k, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO,"1");
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveSIServices");            
        return sir;
    }

    public org.dvb.si.SIRequest retrieveSIService(short word0, Object obj, SIRetrievalListener siretrievallistener, DvbLocator dvblocator, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO,"with locator : "+dvblocator.toString());
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveSIService",(Object)dvblocator);            
        return sir;
    }

    public org.dvb.si.SIRequest retrievePMTServices(short word0, Object obj, SIRetrievalListener siretrievallistener, int i, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TRACE);
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrievePMTServices");    
		return sir;
    }

    public org.dvb.si.SIRequest retrievePMTService(short word0, Object obj, SIRetrievalListener siretrievallistener, DvbLocator dvblocator, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO,"4");
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrievePMTService");            
        return sir;
    }

    public org.dvb.si.SIRequest retrievePMTElementaryStreams(short word0, Object obj, SIRetrievalListener siretrievallistener, int i, int j, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO,"5");
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrievePMTElementaryStreams");            
        return sir;
    }

    public org.dvb.si.SIRequest retrievePMTElementaryStreams(short word0, Object obj, SIRetrievalListener siretrievallistener, DvbLocator dvblocator, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrievePMTElementaryStreams");            
        return sir;
    }

    public org.dvb.si.SIRequest retrieveSITimeFromTDT(short word0, Object obj, SIRetrievalListener siretrievallistener) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveSITimeFromTDT"); 
    	return sir;
    }

    public org.dvb.si.SIRequest retrieveSITimeFromTOT(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveSITimeFromTOT"); 
    	return sir;
    }

    public org.dvb.si.SIRequest retrieveSITransportStreamDescription(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveSITransportStreamDescription");            
        return sir;
    }

    public void addNetworkMonitoringListener(SIMonitoringListener simonitoringlistener, int i) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
    }

    public void removeNetworkMonitoringListener(SIMonitoringListener simonitoringlistener, int i) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
    }

    public void addBouquetMonitoringListener(SIMonitoringListener simonitoringlistener, int i) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
    }

    public void removeBouquetMonitoringListener(SIMonitoringListener simonitoringlistener, int i) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
    }

    public void addServiceMonitoringListener(SIMonitoringListener simonitoringlistener, int i, int j) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
    }

    public void removeServiceMonitoringListener(SIMonitoringListener simonitoringlistener, int i, int j) throws SIIllegalArgumentException    {
		Out.printMe(Out.TODO);
    }

    public void addPMTServiceMonitoringListener(SIMonitoringListener simonitoringlistener, int i, int j, int k) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
    }

    public void removePMTServiceMonitoringListener(SIMonitoringListener simonitoringlistener, int i, int j, int k) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
    }

    public void addEventPresentFollowingMonitoringListener(SIMonitoringListener simonitoringlistener, int i, int j, int k) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
    }

    public void removeEventPresentFollowingMonitoringListener(SIMonitoringListener simonitoringlistener, int i, int j, int k) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
    }

    public void addEventScheduleMonitoringListener(SIMonitoringListener simonitoringlistener, int i, int j, int k, Date date, Date date1) throws SIIllegalArgumentException, SIInvalidPeriodException    {
        Out.printMe(Out.TODO);
    }

    public void removeEventScheduleMonitoringListener(SIMonitoringListener simonitoringlistener, int i, int j, int k) throws SIIllegalArgumentException    {
        Out.printMe(Out.TODO);
	}

// FROM PMTSERVICE
	public SIRequest retrievePMTElementaryStreams(short a, Object obj, SIRetrievalListener siretrievallistener, short[] ss) {
		Out.printMe(Out.TODO,"Additional method from PMTService");
        SIRequest sir = new SIRequestImpl();
        requestHandler.addRequest(obj,sir,siretrievallistener,"retrievePMTElementaryStreams"); 
    	return sir;
	}

	class RequestHandler implements Runnable {
		Thread handlerThread;
		LinkedList requests;
		LinkedList listeners;
		LinkedList appDatas;
		LinkedList requestIDs;
		LinkedList objects;
				
		public RequestHandler() {
			requests = new LinkedList();
			listeners = new LinkedList();
			appDatas = new LinkedList();
			requestIDs = new LinkedList();
			objects = new LinkedList();
			
			handlerThread = new Thread(this);
			handlerThread.start();
			Out.printMe(Out.TRACE,"org.openmhp.si.SIRequestHandler thread started");
		}	
		
		public void run() {
			while (true) {
				try {
					handlerThread.sleep(500);
					handleRequest();
				}
				catch (Exception e) { }
			}	
		}

		public void addRequest(Object a, SIRequest r, SIRetrievalListener l, String id) {
			Out.printMe(Out.TRACE,"****************************** SIRequest added : "+id);
			appDatas.add(a);
			requests.add(r);
			listeners.add(l);	
			requestIDs.add(id);
			objects.add(new String("none"));
		}

		public void addRequest(Object a, SIRequest r, SIRetrievalListener l, String id, Object object) {
			Out.printMe(Out.TRACE,"****************************** SIRequest added : "+id);
			appDatas.add(a);
			requests.add(r);
			listeners.add(l);	
			requestIDs.add(id);
			objects.add(object);
		}

		private void handleRequest() {
			if (requests.size()>0) {
				Object appData = appDatas.removeFirst();
				SIRequest request = (SIRequest)requests.removeFirst();	
				SIRetrievalListener listener = (SIRetrievalListener)listeners.removeFirst();
				String id = (String)requestIDs.removeFirst();
				Object object = (Object)objects.removeFirst();
				
				if (id.equals("retrieveSIService")) {
					DvbLocator loc = (DvbLocator)object;
					Vector v = SIDataEmulation.getInstance().getSIServices();
					int i = 0;
					while (!((SIServiceImpl)v.get(i)).getDvbLocator().equals(loc)) {
						i++;
					}
					Vector r = new Vector();
					r.add((SIService)v.get(i));
					org.openmhp.si.SIIteratorImpl iter = new org.openmhp.si.SIIteratorImpl(r.elements());    	
					Out.printMe(Out.TRACE,"## request handled ## retrieveSIService");
					listener.postRetrievalEvent(new SISuccessfulRetrieveEvent(appData,request,iter));
					return;					
				}

				if (id.equals("retrieveActualSIServices")) {
					Vector v = SIDataEmulation.getInstance().getServices();
					org.openmhp.si.SIIteratorImpl iter = new org.openmhp.si.SIIteratorImpl(v.elements());    	
					Out.printMe(Out.TRACE,"## request handled ## retrieveActualSIServices");
					listener.postRetrievalEvent(new SISuccessfulRetrieveEvent(appData,request,iter));
					return;					
				}

				if (id.equals("retrieveSINetworks")) {
					Vector v = SIDataEmulation.getInstance().getNetworks();
					org.openmhp.si.SIIteratorImpl iter = new org.openmhp.si.SIIteratorImpl(v.elements());    	
					Out.printMe(Out.TRACE,"## request handled ## retrieveSINetworks");
					listener.postRetrievalEvent(new SISuccessfulRetrieveEvent(appData,request,iter));
					return;					
				}				

				if (id.equals("retrieveSITimeFromTDT")) {
			        SITime time = new SITimeImpl();
        			Vector v = new Vector();
        			v.addElement(time);
        			org.openmhp.si.SIIteratorImpl iter = new org.openmhp.si.SIIteratorImpl(v.elements());
					Out.printMe(Out.TRACE,"## request handled ## retrieveSITimeFromTDT");
					listener.postRetrievalEvent(new SISuccessfulRetrieveEvent(appData,request,iter));
					return;					
				}		

				if (id.equals("retrieveSITimeFromTOT")) {
			        SITime time = new SITimeImpl();
        			Vector v = new Vector();
        			v.addElement(time);
        			org.openmhp.si.SIIteratorImpl iter = new org.openmhp.si.SIIteratorImpl(v.elements());
					Out.printMe(Out.TRACE,"## request handled ## retrieveSITimeFromTOT");
					listener.postRetrievalEvent(new SISuccessfulRetrieveEvent(appData,request,iter));
					return;					
				}		
				
				if (id.equals("retrievePMTServices")) {
					Vector v = SIDataEmulation.getInstance().getPMTServices();
					org.openmhp.si.SIIteratorImpl iter = new org.openmhp.si.SIIteratorImpl(v.elements());    	
					Out.printMe(Out.TRACE,"## request handled ## retrievePMTServices");
					listener.postRetrievalEvent(new SISuccessfulRetrieveEvent(appData,request,iter));
					return;					
				}

				if (id.equals("retrievePMTElementaryStreams")) {
					Vector v = new Vector();//SIDataEmulation.getInstance().getPMTServices();
					v.add(new PMTElementaryStreamImpl());
					org.openmhp.si.SIIteratorImpl iter = new org.openmhp.si.SIIteratorImpl(v.elements());    	
					Out.printMe(Out.TRACE,"## request handled ## retrievePMTElementaryStreams");
					listener.postRetrievalEvent(new SISuccessfulRetrieveEvent(appData,request,iter));
					return;					
				}

				listener.postRetrievalEvent(new SITableNotFoundEvent(appData,request));
        		Out.printMe(Out.TRACE,"## request handled WITH ERROR ## ERROR ");
        	}			
		}
	}

}