package org.openmhp.system;

import java.net.*;
import java.lang.Runtime;
import java.io.*;
import java.awt.*;
import javax.swing.*; 
import java.awt.event.*;
import java.awt.datatransfer.*;

/**
* Output window
*/
public class Output extends JFrame implements MouseListener,ActionListener {

	boolean isOn = true;
	JTextArea textarea;
	JScrollPane scrollpane;
    private Container content;
	JPopupMenu popupmenu; 
    Component owner;
    final String name = "Output";
    private JMenuItem toggle;
	public Output() {
		super();
		setTitle(name);
		//setSize(720,576);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE );
		setResizable(true);
		setVisible(true);
		content = this.getContentPane();
        content.setLayout(new BorderLayout());        
        textarea = new JTextArea(40, 40);
        textarea.setEditable(true);		
        scrollpane = new JScrollPane(textarea);
        content.add(scrollpane, BorderLayout.CENTER);

        isOn = true;
        PrintStream ps = new PrintStream(new OS());
        System.setOut(ps);
        System.setErr(ps);
        
        textarea.addMouseListener(this);
		popupmenu = new JPopupMenu();
		
		toggle = new JMenuItem("Output off");
		toggle.addActionListener(this);
		toggle.setActionCommand("toggle");
		popupmenu.add(toggle);
		
		/*
		JMenuItem copy = new JMenuItem("copy");
		copy.addActionListener(this);
		copy.setActionCommand("copy");
		popupmenu.add(copy);
		*/

		JMenuItem tree = new JMenuItem("tree");
		tree.addActionListener(this);
		tree.setActionCommand("tree");
		popupmenu.add(tree);

        pack();		
	}

	public void setOwner(Component c) {
		owner = c;	
	}

	public void print(String s) {
        if(isOn) {
            textarea.append(s);
            textarea.setCaretPosition(textarea.getDocument().getLength());
        }		
	}

	class OS extends OutputStream {
		private byte buffer[] = new byte[1];
		
		public void write( int b ) throws IOException {
    		print( new String( new byte[]{ (byte)b },0, 1 ));
  		}
		
		public void write( byte b[] ) throws IOException {
    		print(new String( b, 0, b.length ));
  		}

  		public void write( byte b[], int off, int len ) throws IOException {
    		print(new String( b, off, len ));
  		}

  		public void flush() throws IOException {  }
		
		public void close() throws IOException {  }		
	} // end class


	// mouselistener
	public void mouseClicked(MouseEvent e) { 
		if (e.getButton()==MouseEvent.BUTTON3) {
			popupmenu.show(textarea, e.getX(), e.getY());
          
		}
	}
	public void mousePressed(MouseEvent e) { }
	public void mouseReleased(MouseEvent e) { }
	public void mouseEntered(MouseEvent e) { }
	public void mouseExited(MouseEvent e){ }

	
	//actionlistener
	public void actionPerformed(ActionEvent ae) {
		String cmd = ae.getActionCommand();
		if (cmd == "copy") {
			String text = textarea.getSelectedText();
			Toolkit tk = Toolkit.getDefaultToolkit();
			tk.getSystemClipboard().setContents(new ClippedText(text),null);	
		}
		if (cmd == "tree") {
			owner.list(System.out,10);
		}
		if (cmd == "toggle") {
			if (isOn) { 
				isOn = false;
				textarea.setBackground(new Color(210,210,210));
				setTitle(name+" < STOPPED >");
				toggle.setText("Output on");
			}
			else { 
				isOn = true;
				textarea.setBackground(Color.white);
				setTitle(name+" < RUNNING >");
				toggle.setText("Output off");
			}
		}		
	}

	class ClippedText implements Transferable {
		Object data;
		DataFlavor[] dataflavors;
		public ClippedText(String s) {	
			data = s;
		 	dataflavors = new DataFlavor[]{	DataFlavor.plainTextFlavor };
		}
		
		public DataFlavor[] getTransferDataFlavors() { return dataflavors; }

		public boolean isDataFlavorSupported(DataFlavor flavor) { return true; }

		public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
			return data;
		}
	}

}