package org.openmhp.system;

import java.awt.*;

import org.openmhp.util.LinkedList;

/**
* Layer for subtitles
*
* @author tejopa
* @date 12.3.2004
* TODO do properly, map through adaptation layer
* 28.4.2004 Changed subtitle layer to do repaint only if subtitles are on, tejopa
*/
public class SubtitleLayer extends Container implements Runnable {

	static String[] subs = { " ", " " };
	static int index = 0;
	static SubtitleLayer instance;
	static SrtSubs srtSubs = null;
	static String currentFile = "";
	static long time = 0;
	static boolean needsRepaint = false;


	static Thread thread;
	Font font = new Font("Tireasias",Font.BOLD,38);
	static String currentText = "";

	static boolean subtitlesOn = true;

	protected SubtitleLayer() {
		super();
		setSize(720,576);
	}

	public static SubtitleLayer getInstance() {
		if (instance==null) {
			instance = new SubtitleLayer();
			thread = new Thread(instance,"SubtitlesThread");
			thread.start();
		}
		return instance;
	}


	public void setSubtitles(String file) {
		srtSubs = new SrtSubs(file);
		time = 0;
	}


	public void setSubtitles(boolean b) {
		subtitlesOn = b;
	}

	public boolean isSubtitlingOn() {
		return subtitlesOn;
	}

	private String getCurrentText() {
		if (subtitlesOn) {
			return currentText;
		}
		else {
			return "";
		}
	}

	private void changeText() {
		if (srtSubs==null) {
			if (index>=subs.length) { index = 0; }
			currentText = subs[index];
			index++;
		}
		else {
			String[] l = srtSubs.next().getLines();
			String text = "";
			for (int i=0;i<l.length;i++) {
				text+=l[i]+"\n";
			}
			currentText = text;
		}
	}


	public void paint(Graphics g) {
		g.setFont(font);

		LinkedList lines = new LinkedList();
		String t = getCurrentText();
		while (t.indexOf('\n')!=-1) {
			lines.add(t.substring(0,t.indexOf('\n')));
			t = t.substring(t.indexOf('\n')+1,t.length());
		}
		lines.add(t);

		int ypos = 460;
		for (int i=0;i<lines.size();i++) {
			g.setColor(Color.BLACK);
			g.drawString((String)lines.get(i),72,ypos-2);
			g.drawString((String)lines.get(i),68,ypos-2);
			g.drawString((String)lines.get(i),68,ypos+2);
			g.drawString((String)lines.get(i),72,ypos+2);
			g.setColor(Color.WHITE);
			g.drawString((String)lines.get(i),70,ypos);
			ypos+=38;
		}
		super.paint(g);
	}

	public void run() {
		while (true) {
			try {
				thread.sleep(4000);
				if (subtitlesOn) {
					changeText();
					repaint();
				}
			}
			catch (Exception e) { }
		}
	}


}