package org.openmhp.system;

import java.awt.*;
import java.io.*;
import java.net.*;
import javax.media.*;
import javax.media.protocol.DataSource;
import javax.tv.locator.Locator;
import javax.tv.media.AWTVideoSize;
import javax.tv.service.selection.ServiceContentHandler;
import javax.tv.service.selection.ServiceMediaHandler;

import org.havi.ui.*;

import org.dvb.media.*;
import org.openmhp.media.*;
import org.davic.media.*;

import org.openmhp.util.Out;

public class VideoLayer extends Container  {

	public static final int STILL_IMAGE 		= 1;
	public static final int VIDEO 				= 2;
	public static final int IMAGE_SEQUENCE 	= 3;

    private static VideoLayer instance;
    private AWTVideoSizeControlImpl awtVideoSizeControl;
    private AWTVideoSize size;
    private Player player;
	private String bgImage = "";
	private String bgVideo = "";

	private int mode = 1;

	BackgroundVideoPresentationControlImpl backgroundVideoPresentationControl; 
	
	SubtitlingLanguageControl subtitlingLanguageControl;
	MediaSelectControlImpl mediaSelectControl;

    private VideoLayer()    {
    	Out.println(this,"creation");
        awtVideoSizeControl = AWTVideoSizeControlImpl.getInstance();
        backgroundVideoPresentationControl = BackgroundVideoPresentationControlImpl.getInstance();
        size = awtVideoSizeControl.getDefaultSize();
        subtitlingLanguageControl = new SubtitlingLanguageControlImpl();
        mediaSelectControl = new MediaSelectControlImpl();
        setSize(720,576);
    }

    public static VideoLayer getInstance()    {
        if(instance == null)
            instance = new VideoLayer();
        return instance;
    }

	public void setMode(int i) {
		mode = i;	
	}

    private void createImagePlayer(String s)    {
        if(s != null) {
            player = new StillImagePlayer(s);
            add(player.getVisualComponent());
			System.out.println(player.getVisualComponent().toString());
        }
    }

	private Component visualComponent = null;
/*
	class Teksti extends Component implements Runnable {
		public Teksti() {
			setSize(720,576);
			new Thread(this).start();	
		}	
		public void run() {
			while (true) {
				try { Thread.currentThread().sleep(100); } catch (Exception e) { }	
				repaint();
			}
		}
		public void paint(Graphics g) {
			String text =" skljgns lkejg smldigj smoigj emoi";
			g.setColor(Color.red);
			g.drawString(text,(int)(Math.random()*720),(int)(Math.random()*576));
		}
	}
*/


    private void createVideoPlayer(String s)    {
        if(s != null) {
            player = new VideoPlayer(s);
            add(player.getVisualComponent());
            //hScene.add(player.getVisualComponent());
            
            player.start();
        }
    }


	private HScene hScene = null;

	public void setHScene(HScene scene) {
		hScene = scene;
	}


	public void setBackgroundImage(String s) {
		bgImage = s;
	}
	
	public void setBackgroundVideo(String s) {
		bgVideo = s;
	}
	
	public void start() {
		if (mode==STILL_IMAGE) {
			Out.printMe(Out.TRACE,"Creating ImagePlayer..");
			createImagePlayer(bgImage);
		}
		if (mode==VIDEO) {
			createVideoPlayer(bgVideo);	
		}
	}

	public Object getVideoController() {
		return player;	
	}

	public Player getPlayer() {
		return player;	
	}

    public Control getControl(String s)
    {
    	Out.println(this,"getControl requested with parameter : "+s);
        if(s.equals("javax.tv.media.AWTVideoSizeControl")) {
            Out.println(this,"returns AWTVideoSizeControl");
            return awtVideoSizeControl;
        }
        if(s.equals("org.dvb.media.BackgroundVideoPresentationControl")) {
            Out.println(this,"returns AWTVideoSizeControl");
            return backgroundVideoPresentationControl;
        }

        if(s.equals("javax.tv.media.MediaSelectControl")) {
            Out.println(this,"returns javax.tv.media.MediaSelectControl");
            return mediaSelectControl;
    	}

        if(s.equals("org.davic.media.SubtitlingLanguageControl")) {
            Out.println(this,"returns SubtitlingLanguageControl");
            return subtitlingLanguageControl;
    	}
         else
        {
        	Out.println(this,"request: >"+s+"< returns null FIXME");
            return null;
        }
    }

    public Control[] getControls() {
    	Out.println(this,"getControls returning 4 controls");
        Control acontrol[] = new Control[4];
        acontrol[0] = awtVideoSizeControl;
		acontrol[1] = backgroundVideoPresentationControl;
		acontrol[2] = subtitlingLanguageControl; 
		acontrol[3] = mediaSelectControl; 		       
        return acontrol;
    }


    public void paint(Graphics g)  {
    	//Out.println(this,"paint");
        if(player != null) {
        	
            awtVideoSizeControl = AWTVideoSizeControlImpl.getInstance();
            size = awtVideoSizeControl.getSize();
            int i = size.getDestination().x;
            int j = size.getDestination().y;
            int k = size.getDestination().width;
            int l = size.getDestination().height;
            Component component = player.getVisualComponent();
            
            //component.setBounds(this.getBounds());
            
            // do awt transformation
            if ((i!=0)|(j!=0)|(k!=720)|(l!=576)) {
	            component.setBounds(i, j, k, l);
			}	    		
                    
            backgroundVideoPresentationControl = BackgroundVideoPresentationControlImpl.getInstance();
            VideoTransformation vt = backgroundVideoPresentationControl.getVideoTransformation();
           	
           	if (vt!=null) {
           		Rectangle rect = vt.getClipRegion();
		       	i = (int)(vt.getVideoPosition().x*720);
        	    j = (int)(vt.getVideoPosition().y*576);
            	k = (int)(rect.width*vt.getScalingFactors()[0]);
            	l = (int)(rect.height*vt.getScalingFactors()[1]);
            	
		    	//if ((i!=0)|(j!=0)|(k!=720)|(l!=576)) {
	    	        component.setBounds(i, j, k, l);
				//}	    		

            }
		}
		        
         super.paint(g);
        
    }


}