package org.davic.mpeg;

/**
* @author tejopa
* @date 11.2.2004
* @date 14.11.2004 doc
* @status fully implemented
* @module internal
*/
public interface NotAuthorizedInterface {

	public final static int POSSIBLE_UNDER_CONDITIONS = 0;
	public final static int NOT_POSSIBLE = 1;

	public final static int COMMERCIAL_DIALOG = 1;
	public final static int MATURITY_RATING_DIALOG = 2;
	public final static int TECHNICAL_DIALOG = 3;
	public final static int FREE_PREVIEW_DIALOG = 4;

    public final static int NO_ENTITLEMENT = 1;
	public final static int MATURITY_RATING = 2;
	public final static int TECHNICAL = 3;
	public final static int GEOGRAPHICAL_BLACKOUT = 4;
	public final static int OTHER = 5;

	public final static int SERVICE = 0;
	public final static int ELEMENTARY_STREAM = 1;

	/**
	*	SERVICE or ELEMENTARY_STREAM to indicate that
	*	either a service (MPEG program) or one or more
	*	elementary streams could not be descrambled.
	*/
    public int getType();

	/**
	*	If getType() returns SERVICE, then this method
	*	returns the Service that could not be descrambled.
	*	Otherwise it returns null.
	*/
    public Service getService();

	/**
	*	If getType() returns ELEMENTARY_STREAM, then this
	*	method returns the set of ElementaryStreams that
	*	could not be descrambled. Otherwise it returns null.
	*/
    public ElementaryStream[] getElementaryStreams();

	/**
	* Returns the reason(s) why descrambling was not possible.
	*/
    public int[] getReason(int index) throws java.lang.IndexOutOfBoundsException;
}







