package org.davic.mpeg.sections;

import org.davic.mpeg.*;
import org.openmhp.util.*;
import org.davic.resources.*;

/**
* @author tejopa
* @date 7.3.2004
* @date 14.11.2004 added implementation code, docs
* @status partially implemented
* @module internal
* @HOME

This class represents a group of MPEG-2 section filters to be activated and de-activated as an atomic operation. The purpose of this class is to minimize the potential for resource deadlock between independent pieces of application(s).

*/
public class SectionFilterGroup implements 	org.davic.resources.ResourceProxy, org.davic.resources.ResourceServer{

	LinkedList filters;
	LinkedList listeners;
	TransportStream source;
	ResourceClient resourceClient;
	Object appData;

	boolean connected = false;

	int filterCount = 0;
	boolean highPriority = false;

	/**
        Creates a section filter group object with an associated number of section filters needed to be reserved when the object is to be connected to an active source of MPEG-2 sections. The object will have a default high resource priority should the number of section filters available to the package become insufficient.

    Parameters:
        numberOfFilters - the number of section filters needed for the object.
    Throws:
        IlegalArgumentException - if numberOfFilters is less than one.

	*/
	public SectionFilterGroup(int numberOfFilters){
		Out.printMe(Out.TRACE);
		if (numberOfFilters<0) throw new IllegalArgumentException();
		filterCount = numberOfFilters;
		filters = new LinkedList();
		listeners = new LinkedList();
	}

	/**
		Creates a section filter group object with an associated number of section filters needed to be reserved when the object is to be connected to an active source of MPEG-2 sections.

		Parameters:
			numberOfFilters - the number of section filters needed for the object
			resourcePriority - the resource priority of the object should the number of section filters available to the package become insufficient. High priority is indicated by true and low priority by false. The scope of the resourcePriority shall be a single application only.
		Throws:
			IlegalArgumentException - if numberOfFilters is less than one.


	*/
	public SectionFilterGroup(int numberOfFilters, boolean resourcePriority){
		Out.printMe(Out.TRACE);
		if (numberOfFilters<0) throw new IllegalArgumentException();
		filterCount = numberOfFilters;
		highPriority = resourcePriority;
	}

	/**
    Specifies an object to be notified of changes in the status of resources related to a SectionFilterGroup object. If this call is made more than once, each specified listener will be notified of each change in resource status.

    Specified by:
        addResourceStatusEventListener in interface ResourceServer

    Parameters:
        listener - the object to be notified
	*/
	public void addResourceStatusEventListener (org.davic.resources.ResourceStatusListener listener){
		Out.printMe(Out.TRACE);
		listeners.add(listener);
	}

	/**
	Creates a new simple section filter object within the parent section filter group. On activation (succesfull startFiltering) the SimpleSectionFilter object will use section filters from the total specified when the parent SectionFilterGroup was created. The section filter object will have a buffer suitable to hold a default long section.
	*/
	public SimpleSectionFilter newSimpleSectionFilter(){
		Out.printMe(Out.TODO,"returns null");
		return null;
	}

	/**
    Indicates that an object is no longer to be notified of changes in the status of resources as setup by addResourceStatusEventListener. If an object was not specified as to be notified then this method will be have no effect.

    Specified by:
        removeResourceStatusEventListener in interface ResourceServer

    Parameters:
        listener - the object no longer to be notified

	*/
	public void removeResourceStatusEventListener (org.davic.resources.ResourceStatusListener listener){
		Out.printMe(Out.TRACE);
		listeners.remove(listener);
	}

	/**
    Connects a SectionFilterGroup to an MPEG-2 transport stream. The SectionFilterGroup will attempt to acquire the number of section filters specified when it was created. Any SectionFilter objects which are part of the group concerned and whose filtering has been started will become active and start filtering the source for sections matching the specified patterns. A call to attach on a attached SectionFilterGroup will be treated as a detach followed by the new attach.

    Parameters:
        stream - specifies the source of MPEG-2 sections for filtering
        client - specifies an object to be notified if the section filters acquired during this method are later removed by the environment for any reason.
        requestData - application specific data for use by the resource notification API
    Throws:
        FilterResourceException - if reserving the specified section filters fails
        InvalidSourceException - if the source is not a valid source of MPEG-2 sections.
        TuningException - if the source is not currently tuned to
        NotAuthorizedException - if the information requested is scrambled and permission to descramble it is refused.

	*/
	public void attach(org.davic.mpeg.TransportStream stream, org.davic.resources.ResourceClient client, Object requestData) throws FilterResourceException, InvalidSourceException, org.davic.mpeg.TuningException,org.davic.mpeg.NotAuthorizedException {
		Out.printMe(Out.TODO);
		detach();
		source = stream;
		resourceClient = client;
		appData = requestData;
		connected = true;
	}

	/**
	Returns a SectionFilterGroup to the disconnected state. When called for a SectionFilterGroup in the connected state, it disconnects a SectionFilterGroup from a source of MPEG-2 sections. The section filters held by the SectionFilterGroup will be released back to the environment. Any running filtering operations will be terminated. This method will have no effect for SectionFilterGroups already in the disconnected state.
	*/
	public void detach(){
		Out.printMe(Out.TODO);
		connected = false;
	}



	public SimpleSectionFilter newSimpleSectionFilter(int sectionSize){
		Out.printMe(Out.TODO,"returns null");
		return null;
	}

	public RingSectionFilter newRingSectionFilter(int ringSize){
		Out.printMe(Out.TODO,"returns null");
		return null;
	}

	public RingSectionFilter newRingSectionFilter(int ringSize, int  sectionSize){
		Out.printMe(Out.TODO,"returns null");
		return null;
	}

	public TableSectionFilter newTableSectionFilter(){
		Out.printMe(Out.TODO,"returns null");
		return null;
	}

	public TableSectionFilter newTableSectionFilter(int sectionSize){
		Out.printMe(Out.TODO,"returns null");
		return null;
	}


	/**
	Returns the MPEG-2 transport stream to which a SectionFilterGroup is currently connected. If the SectionFilterGroup is not connected to a transport stream then the method will return null.
	*/
	public org.davic.mpeg.TransportStream getSource(){
		Out.printMe(Out.TRACE);
		if (connected) return source;
		else return null;
	}

	/**
		Returns the ResourceClient object specified in the last call to the attach() method as to be notified in the case that the section filters acquired by the SectionFilterGroup during that call to attach() are removed by the environment for any reason. If the SectionFilterGroup is not connected to a source then the method will return null.

		Specified by:
			getClient in interface ResourceProxy

		Following copied from interface: org.davic.resources.ResourceProxy

		Returns:
			the object which asked to be notified about withdrawal of the underlying physical resource from a resource proxy.
	*/
	public org.davic.resources.ResourceClient getClient(){
		Out.printMe(Out.TRACE);
		if (connected) return resourceClient;
		else return null;
	}





}
