package org.davic.net.dvb;

import org.davic.net.InvalidLocatorException;
import org.openmhp.util.Out;

/**
* @author tejopa
* @date 7.3.2004
* @date 14.11.2004 partially implemented
* @status partially implemented
* @module internal
* @HOME

DVB Locator that is bound to a network. An object of this type identifies uniquely a given entity and the delivery system in which it is carried.

For example, a service may be carried in both satellite and terrestrial networks and the DvbLocator identifying that service may be common, but both of them will have a different DvbNetworkBoundLocator.

*/
public class DvbNetworkBoundLocator extends org.davic.net.dvb.DvbLocator implements org.davic.net.TransportDependentLocator {

	DvbLocator unboundLocator;
	int networkId = 0;

	public DvbNetworkBoundLocator(DvbLocator unboundLocator, int networkId) throws InvalidLocatorException {
		super(unboundLocator.getOriginalNetworkId(), unboundLocator.getTransportStreamId(), unboundLocator.getServiceId());
		this.unboundLocator = unboundLocator;
		this.networkId = networkId;
		Out.printMe(Out.TRACE);
	}

	public int getNetworkId() {
		Out.printMe(Out.TRACE);
		return networkId;
	}

}

