package org.dvb.event ;

import java.util.EventObject;
import java.awt.event.*;

/**
* @author tejopa
* @date 5.3.2004
* @status fully implemented
* @module internal
*/
public class UserEvent extends EventObject {

    public static final int UEF_KEY_EVENT=1 ;
    private int family;
    private int type;
    private int code;
    private int modifiers;
    private char keyChar;

    public UserEvent(Object source, int a_family, char a_keyChar) {
        super(source);
        family = a_family;
        keyChar = a_keyChar;
    }

    public UserEvent(Object source, int a_family, int a_type, int a_code, int a_modifiers) {
        super(source);
        family = a_family;
        type = a_type;
        code = a_code;
        modifiers = a_modifiers;
    }

    public int getCode(){
        return code;
    }

    public int getFamily(){
        return family;
    }
    
    public char getKeyChar(){
        return keyChar;
    }

    public int getModifiers(){
        return modifiers;
    }


    public int getType(){
        return type;
    }

    public boolean isAltDown(){
        boolean result = false;
        if ((modifiers&KeyEvent.ALT_MASK)!=0) {
        	result = true;	
        }
        return result;
    }

    public boolean isControlDown(){
        boolean result = false;
        if ((modifiers&KeyEvent.CTRL_MASK)!=0) {
        	result = true;	
        }
        return result;
    }

    public boolean isMetaDown(){
        boolean result = false;
        if ((modifiers&KeyEvent.META_MASK)!=0) {
        	result = true;	
        }
        return result;
    }

    public boolean isShiftDown(){
        boolean result = false;
        if ((modifiers&KeyEvent.SHIFT_MASK)!=0) {
        	result = true;	
        }
        return result;
    }

}
