package org.dvb.lang;

import java.net.URL;
import org.openmhp.adaptation.resources.DVBClassLoaderImpl;

/**
* This implementation creates an instance from DVBClassLoaderImpl class. This
* instance is then used when a client calls findClass.
*
*
* @author tejopa
* @date 7.3.2004
* @status partially implemented
* @module internal
* @HOME
*/
public abstract class DVBClassLoader extends java.security.SecureClassLoader {

	protected URL[] searchPaths;
	protected ClassLoader parentClassLoader;
	private static DVBClassLoaderImpl instance;

	public DVBClassLoader(URL[] urls){
		searchPaths = urls;
	}

    public DVBClassLoader(URL[] urls, ClassLoader parent){
		searchPaths = urls;
		parentClassLoader = parent;
    }

    public Class findClass(String name) throws ClassNotFoundException {
		return instance.findClass(name);
    }

    public static DVBClassLoader newInstance(URL[] urls){
		if (instance==null) instance = new DVBClassLoaderImpl(urls);
		return (DVBClassLoader)instance;
    }

    public static DVBClassLoader newInstance(URL[] urls, ClassLoader parent){
		if (instance==null) instance = new DVBClassLoaderImpl(urls,parent);
		return (DVBClassLoader)instance;
    }

}
