package org.dvb.user;

/**
* @author tejopa
* @date 7.3.2004
* @date 1.12.2004 docs
* @status fully implemented
* @module internal
* @HOME

Description
This class is for user preference and setting permissions. A UserPreferencePermission contains a name,
but no actions list.
The permission name can either be "read" or "write". The "read" permission allows an application to read
the user preferences and settings (using UserPreferenceManager.read) for which read access is
not always granted. Access to the following settings/preferences is always granted: "User Language",
"Parental Rating", "Default Font Size" and "Country Code"
The "write" permission allows an application to modify user preferences and settings (using
UserPreferenceManager.write).

*/
public class UserPreferencePermission extends java.security.BasicPermission {

	/**
	Creates a new UserPreferencePermission with the speci?ed name. The name is the symbolic name
	of the UserPreferencePermission.
	Parameters:
	name - the name of the UserPreferencePermission
	*/
	public UserPreferencePermission(String name){
		super(name);
	}

	/**
	Creates a new UserPreferencePermission object with the speci?ed name. The name is the symbolic
	name of the UserPreferencePermission, and the actions String is unused and should be null. This
	constructor exists for use by the Policy object to instantiate new Permission objects.
	Parameters:
	name - the name of the UserPreferencePermission
	actions - should be null.
	*/
	public UserPreferencePermission(String name, String actions){
		super(name,actions);
	}

}

