package org.havi.ui;

import java.awt.*;
import org.openmhp.util.Out;

/**
* @author tejopa
* @date 6.3.2004
* @date 6.4.2004 fully implemented
* @status fully implemented
* @module internal
* @tested no
* @TODO better drawing, check maximum, preferred and minimum sizes
*/
public class HAnimateLook implements HLook{

	private Insets currentInsets = new Insets(0,0,0,0);

    public HAnimateLook(){
		Out.printMe(Out.TRACE);
	}

	/* tejopa 6.4.2004 */
    public java.awt.Insets getInsets(HVisible visible){
		Out.printMe(Out.TRACE);
        return currentInsets;
    }

	/* tejopa 6.4.2004 */
    public Dimension getMaximumSize(HVisible hvisible){
		Out.printMe(Out.TRACE);
        return hvisible.getSize();
    }

	/* tejopa 6.4.2004 */
    public Dimension getMinimumSize(HVisible hvisible){
		Out.printMe(Out.TRACE);
        return hvisible.getMinimumSize();
	}

	/* tejopa 6.4.2004 */
    public Dimension getPreferredSize(HVisible hvisible){
		Out.printMe(Out.TRACE);
        return hvisible.getDefaultSize();
    }

	/* tejopa 6.4.2004 */
    public boolean isOpaque(HVisible visible){
		Out.printMe(Out.TRACE);
        return visible.isOpaque();
    }
    
	/* tejopa 6.4.2004 */
    public void showLook(java.awt.Graphics g, HVisible hvisible, int state){
		
		Dimension d = hvisible.getSize();
        if (hvisible.getBackgroundMode()==HVisible.BACKGROUND_FILL){
            Color c = hvisible.getBackground();
            if(c != null){
                g.setColor(c);
                g.fillRect(0, 0, d.width, d.height);
            }
        }

		Image image = ((HStaticAnimation)hvisible).getCurrentImage();

        if (image!=null) {

            int x = 0;
			int ha = hvisible.getHorizontalAlignment();
            int iw  = image.getWidth(hvisible);
            int w = hvisible.getWidth();

            if(ha==HVisible.HALIGN_CENTER||ha==HVisible.HALIGN_JUSTIFY){
                x = (w/2)-(iw/2);
            }
            if (ha==HVisible.HALIGN_LEFT){
                x = 0;
            }
            if (ha==HVisible.HALIGN_RIGHT){
                x = w-iw;
            }

            int y = 0;
            int va = hvisible.getVerticalAlignment();
            int h = hvisible.getHeight();
            int ih = image.getHeight(hvisible);

            if (va==HVisible.VALIGN_CENTER||va==HVisible.HALIGN_JUSTIFY) {
                y = (h/2)-(ih/2);
            }
            if (va==HVisible.VALIGN_TOP){
                y = 0;
            }
            if (va==HVisible.VALIGN_BOTTOM){
                y = h-ih;
            }

            g.drawImage(image, x, y, null);

        }
    }

	/* tejopa 6.4.2004 */
    public void widgetChanged (HVisible visible, HChangeData[] changes){
		Out.printMe(Out.TRACE);
		// do the minimum...
		visible.repaint();
    }




}

