package org.havi.ui;

/**
* @author tejopa
* @date 6.3.2004
* @statusfully implemented
* @module internal, graphics
* TODO attach to real HScreens
* HOME
*/
public abstract class HScreenConfigTemplate{

    public static final int REQUIRED                     = 1;
    public static final int PREFERRED                    = 2;
    public static final int DONT_CARE                    = 3;
    public static final int PREFERRED_NOT                = 4;
    public static final int REQUIRED_NOT                 = 5;

    public static final int ZERO_BACKGROUND_IMPACT       = 1;
    public static final int ZERO_GRAPHICS_IMPACT         = 2;
    public static final int ZERO_VIDEO_IMPACT            = 3;
    public static final int INTERLACED_DISPLAY           = 4;
    public static final int FLICKER_FILTERING            = 5;
    public static final int VIDEO_GRAPHICS_PIXEL_ALIGNED = 6;
    public static final int PIXEL_ASPECT_RATIO           = 7;
    public static final int PIXEL_RESOLUTION             = 8;
    public static final int SCREEN_RECTANGLE             = 9;

    private int[] priorities;
    private Object[] objects;

    public HScreenConfigTemplate(){
        priorities = new int[10];
        objects = new Object[10];
        /* set DONT_CARE to each preference */
        for(int i = 0; i < priorities.length; i++){
            priorities[i] = HScreenConfigTemplate.DONT_CARE;
            objects[i] = null;
        }
    }

    public void setPreference(int preference, int priority){
        priorities[preference] = priority;
    }

    public void setPreference(int preference, Object object, int priority){
        priorities[preference] = priority;
        objects[preference] = object;
    }

    public int getPreferencePriority(int preference){
        return priorities[preference];
    }

    public Object getPreferenceObject(int preference){
        return objects[preference];
    }
}
