package org.havi.ui;

import java.awt.*;
import java.util.Vector;
import org.havi.ui.event.HActionEvent;

import org.openmhp.util.LinkedList;
import org.openmhp.util.Out;

// TODO CHECK DEFAULT SETTINGS
/* HOME */
/**
* @author tejopa
* @date 7.3.2004
* @status partially implemented
* @module internal
*/
public class HTextButton extends HText implements HActionable{

    private static HTextLook defaultHLook = new HTextLook();
    //private HLook hLook = defaultHLook;
    private String 	actionCommand;
    private HSound actionSound;
    private HSound loseSound;
    private HSound gainSound;
    private boolean selected = false;

	private LinkedList hActionListeners;
	private LinkedList focusListeners;

	private LinkedList targets;
	private LinkedList keys;

    public HTextButton(){
        super("",0,0,0,0);
        setDefaults();
		setSize(100,30);
    }

    public HTextButton(String textNormal, int x, int y, int width, int height){
        super(textNormal, x, y, width, height);
    	setDefaults();
        setSize(width,height);
        setLocation(x,y);
    }

    public HTextButton(String textNormal, int x, int y, int width, int height, Font font, Color foreground, Color background, HTextLayoutManager tlm){
        super(textNormal, x, y, width, height, font, foreground, background, tlm);
        setDefaults();
        setSize(width,height);
        setLocation(x,y);
    }

    public HTextButton(String textNormal){
        super(textNormal);
        setDefaults();
    }

    public HTextButton(String textNormal, Font font, Color foreground, Color background, HTextLayoutManager tlm){
        super(textNormal, font, foreground, background, tlm);
        //setDefaults();
    }

	private void setDefaults() {
		setBounds(0,0,0,0);
		setTextToAllStates(null);
		setTextLayoutManager(new HDefaultTextLayoutManager());
		//setFont();
		try {
			setMatte(null);
		}
		catch (Exception e) { System.out.println(e); }
		setBackgroundMode(NO_BACKGROUND_FILL);
		setDefaultSize(null);

		setHorizontalAlignment(HALIGN_CENTER);
		setVerticalAlignment(HALIGN_CENTER);
		setResizeMode(RESIZE_NONE);
		//TODO TEXTLOOK
		setDefaultLook(new HTextLook()); // PLATFORM SPECIFIC LOOK
		try {
			setLook(getDefaultLook());
		}
		catch (Exception e) { System.out.println(e); }

		setGainFocusSound(null);
		setLoseFocusSound(null);
		setActionSound(null);

		hActionListeners = new LinkedList();
		focusListeners = new LinkedList();
		
		targets = new LinkedList();
		keys = new LinkedList();
		
	}

    public void addHActionListener(org.havi.ui.event.HActionListener listener){
        hActionListeners.add(listener);
    }

    public String getActionCommand(){
        return actionCommand;
    }

    public static void setDefaultLook(HTextLook hLook){
        defaultHLook = hLook;
    }

    public static HTextLook getDefaultLook(){
        return defaultHLook;
    }

    public void setMove(int keyCode, HNavigable target){
        if (keys==null) {
        	targets = new LinkedList();
        	keys   = new LinkedList();	
        }

        Integer newcode = new Integer(keyCode);
		int index = keys.indexOf(newcode);
		
		if (index!=-1) {
			keys.remove(keys.get(index));
			targets.remove(targets.get(index));
		}
		keys.add(newcode);
		targets.add(target);
    }

    public HNavigable getMove(int keyCode){
		int index = keys.indexOf(new Integer(keyCode));
		if (index!=-1) {
			return (HNavigable)targets.get(index);	
		}
		else {
			return null;	
		}
    }

    public void setFocusTraversal(HNavigable up, HNavigable down, HNavigable left, HNavigable right){
		Out.printMe(Out.TODO);
    }

    public boolean isSelected(){
        return selected;
    }

    public void setGainFocusSound(HSound sound){
        gainSound = sound;
    }

    public void setLoseFocusSound(HSound sound){
        loseSound = sound;
    }

    public HSound getGainFocusSound(){
        return gainSound;
    }

    public HSound getLoseFocusSound(){
        return loseSound;
    }

    public void addHFocusListener(org.havi.ui.event.HFocusListener l){
		focusListeners.add(l);
    }

    public void removeHFocusListener(org.havi.ui.event.HFocusListener l){
		focusListeners.remove(l);
    }

    public int[] getNavigationKeys(){
		Out.printMe(Out.TODO);
    	return null;
    }

    public void processHFocusEvent(org.havi.ui.event.HFocusEvent evt){
		Out.printMe(Out.TODO);
    }

    public void removeHActionListener(org.havi.ui.event.HActionListener listener){
        hActionListeners.remove(listener);
    }

    public void setActionCommand(String command){
        actionCommand = command;
    }

    public void setActionSound(HSound sound){
        actionSound = sound;
    }

    public HSound getActionSound(){
        return actionSound;
    }

    public void processHActionEvent(HActionEvent evt){
		Out.printMe(Out.TODO);
    }



}
