package org.havi.ui.event;

import org.openmhp.util.Out;

/**
 * @author tejopa
 * @date 13.2.2004
 * @status fully implemented
 * @module internal
 *
 * inspected 12.2.2004
 * ready 13.2.2004
 */
public class HActionEvent extends java.awt.event.ActionEvent{
    
    String command;
    
    /**
     * Parameters:
     * source - The HActionable component which has been actioned.
     * id - The event id of the HActionEvent generated by the HActionable component. This is
     * the value that will be returned by the event object's getID method.
     * command - A String which is used as the action command string for this event.
     */
    public HActionEvent(org.havi.ui.HActionInputPreferred source, int id, String command){
        super(source, id, command);
        command = command;
        Out.printMe(Out.TRACE);
    }
    
    public String getActionCommand(){
        Out.printMe(Out.TRACE);
        return command;
    }
    
    /**
     * Returns any modifiers held down during this action event.
     * Modifiers are not used with the HAVi platform. Interoperable HAVi applications shall not use the
     * return value of this method.
     * Overrides:
     * java.awt.event.ActionEvent.getModifiers() in class java.awt.event.ActionEvent
     * Returns:
     * an implementation-specific value.
     */
    public int getModifiers(){
        Out.printMe(Out.TRACE);
        return 0;
    }
}

