package org.openmhp.system;

import org.dvb.application.*;
import org.openmhp.application.*;
import java.net.*;
import java.io.*;
import java.util.*;

import org.openmhp.util.Out;

/** ApplicationDatabase server
* @author tejopa
* @date 10.12.2004 added public constructor;
*/
public class AppsDatabaseServer implements Runnable {

	private String ip = "";
	public static  final int SERVER_PORT = 50000;
	private Thread serverThread;
	private static AppsDatabaseServer instance;
	private boolean stopRequested = false;
	private ServerSocket serverSocket;

	Vector xlethandlers;

	private static AppsDatabaseImpl appsDatabaseImpl;

	protected AppsDatabaseServer(String i) {
		ip = i;

		createAppsDatabase();

		serverThread = new Thread(this);
		serverThread.start();
	}

	/* 10.12.2004 tejopa */
	public AppsDatabaseServer() {
		ip = "localhost";

		createAppsDatabase();

		serverThread = new Thread(this);
		serverThread.start();
		System.out.println("** org.openmhp.system.AppsDatabaseServer is running **");
	}

	/** Get instance */
	public static AppsDatabaseServer getInstance(String ip) {
		Out.println(new Object(),"AppsDatabaseServer getInstance");

		if (instance==null) { instance = new AppsDatabaseServer(ip); }
		else {
			Out.error(new Object(),"AppsDatabaseServer already created. Can not start other instances");
		}
		return instance;
	}

	private boolean createAppsDatabase() {
		try {
			appsDatabaseImpl = AppsDatabaseImpl.getServerInstance();
			return true;
		}
		catch (Exception e) {
			Out.error(this,"AppsDatabaseImpl could not be created. "+e.toString());
			return false;
		}
	}

	public void stop() {
		stopRequested = true;
	}

	public void run() {
		boolean serverStartFailed = false;
		try {
			Out.println(this,"Trying to create AppsDatabaseServer...");
			serverSocket = new ServerSocket(SERVER_PORT);
			Out.println(this,"Yes. Server is running.");
		}
		catch (IOException e) {
			Out.error(this,"Server did NOT start. Reason: "+e.toString());
			serverStartFailed = true;
		}

		xlethandlers = new Vector();

		if (!serverStartFailed) {
				while (!stopRequested) {
				try {
					Out.println(this,"waiting for connection...");
					ADBRequestHandler adbrh = new ADBRequestHandler(serverSocket.accept(),appsDatabaseImpl,this);
				}
					catch (IOException e) {	Out.error(this,"Failed to create socket! Reason: "+e.toString());			}
				try {	Thread.currentThread().sleep(2000);	}
					catch (Exception e) { Out.error(this,e.toString()); }
				cleanUp();
			}
		}
	}

	public Vector getXletHandlers() {
		return xlethandlers;
	}

	public void cleanUp() {
		Enumeration enum = xlethandlers.elements();
		while (enum.hasMoreElements()) {
			ADBRequestHandler temp = (ADBRequestHandler)enum.nextElement();
			if (!temp.isAlive()) {
				xlethandlers.removeElement(temp);
				Out.printMe(Out.TRACE,"REMOVED XLET CONNECTION");
			}
		}
	}


	public void xletStarted(AppID appid) {
		((AppProxyImpl)appsDatabaseImpl.getAppProxy(appid)).setState(AppProxy.STARTED);
		Enumeration enum = xlethandlers.elements();
		while (enum.hasMoreElements()) {
			ADBRequestHandler temp = (ADBRequestHandler)enum.nextElement();

		}
	}

}