package org.openmhp.system;

import org.openmhp.adaptation.graphics.*;
import org.openmhp.appman.*;
import org.openmhp.util.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * @date 18.1.2005 initial class derived from TVScreen
 */
public class Runtime {
    
    private static boolean debugOn = true;
    private static boolean errorsOn = true;
    
    public Runtime() { }
    
    public static void main(String[] args) {
        
        //SAScreen screen = new SAScreen();
        //GraphicsOutput go = new GraphicsOutput(51234);
        //go.addGraphicsListener(screen);//screen.connectToMHPDevice("127.0.0.1",55000,10);
        
        System.out.println("<MHP RE> : Starting application database server...");
        
        String current = ".";
        
        if (args.length==2) {
            System.out.println("args length == 2");
            if (args[0]!=null) {
                System.out.println("args 0 != null");
                if (args[0].equals("-base")) {
                    System.out.println("args 0 == -base");
                    if (args[1]!=null) {
                        System.out.println("args 1 != null");
                        current = args[1].trim();
                    }
                }
            }
        }
        
        
        /* tejopa 10.12.2004 */
        String FS = File.separator;
        Properties p = Configuration.loadProperties(current+FS+"static"+FS+"openmhp.properties");
        
        /* tejopa 4.4.2005 */
        Properties props = System.getProperties();
        props.put("base_dir",current);
        props.putAll(p);
        System.setProperties(props);
        
        props = System.getProperties();
        
        String javatv_path = System.getProperty("javatv_jar","");
        String jmf_path = System.getProperty("jmf_jar","");
        
        
        XletLoader loader;
        Class loadedClass;
        AppsDatabaseServer server;
        try {
            File f1 = new File(javatv_path);
            File f2 = new File(jmf_path);
            File f3 = new File(System.getProperty("base_dir"));
            System.out.println(f1.toURL());
            System.out.println(f2.toURL());
            System.out.println(f3.toURL());
            
            loader = new XletLoader(new URL[]{f3.toURL()});
            loader.addJars(new URL[]{ f1.toURL(), f2.toURL(), f3.toURL() });
        } catch (Exception e) {
            Out.printMe(Out.ERROR,e.toString());
            return;
        }
        try		{
            loadedClass = loader.loadClass("org.openmhp.system.AppsDatabaseServer");
            loadedClass.newInstance();
            //server = (AppsDatabaseServer)loadedClass.newInstance();
        } catch (Exception e)		{
            System.out.println("<RUNTIME> 1: "+e.toString());
            //System.out.println("<MHP RE> : <ERROR> Could not start server.");
            return;
        }
        //AppsDatabaseServer.getInstance("localhost");
        System.out.println("<MHP RE> : Server is running.");
        System.out.println("<MHP RE> : Launching Application Manager");
        
        try		{
            loadedClass = loader.loadClass("org.openmhp.appman.Appman");
            loadedClass.newInstance();
            //server = (AppsDatabaseServer)loadedClass.newInstance();
        } catch (Exception e)		{
            System.out.println("<RUNTIME> 2: "+e.toString());
            //System.out.println("<MHP RE> : <ERROR> Could not start server.");
            return;
        }
        //new Appman();
    }
    
}