package org.openmhp.system;

import java.net.*;
import java.lang.Runtime;
import java.io.*;
import java.util.*;
import javax.swing.*;

import org.openmhp.util.*;

/*
* 28.4.2004 Changed JMF classpath before JavaTV classpath. tejopa
* 30.3.2005 Creates a policy file using policy/template.policy /tejopa
*
*/
public class Shell {

	static String path;
	static String name;
	static String root;
	static String orgid;
	static String appid;
	static Exception exception;

	public static void main(String[] args) {
    	path = args[0];
    	name = args[1];
    	orgid = args[2];
    	appid = args[3];
    	root = System.getProperty("base_dir");//(new File("")).getAbsolutePath();
    	launch();
	}

	public Shell(String[] args) {
    	path = args[0];
    	name = args[1];
    	orgid = args[2];
    	appid = args[3];
    	root = System.getProperty("base_dir");
    	launch();
	}


	private static void launch()    {

		//Properties props = loadProperties(System.getProperty("base_dir")+"static"+File.separator+"openmhp.properties");

    	String FS = File.separator;
        String cmd = "java";
        String classfile = "org.openmhp.system.RunXlet";


		String classpath =	"."+File.pathSeparator+System.getProperty("base_dir")+File.pathSeparator;
//		classpath +=	root+File.separator+"mhp"+File.pathSeparator;
//		classpath +=	root+File.separator+"JMF2.1.1"+File.separator+"lib"+File.separator+"jmf.jar"+File.pathSeparator;
//		classpath +=	root+File.separator+"javatv_fcs"+File.separator+"javatv.jar"+File.pathSeparator;

		String javatv_path = System.getProperty("javatv_jar","");
		if (javatv_path!="") {
			Out.printMe(Out.TRACE,"javatv.jar path added: "+javatv_path);
			classpath+=javatv_path+File.pathSeparator;;
		}
		else {
			JOptionPane.showMessageDialog(null, "Choose path to JavaTV jar (javatv.jar)");
		}

		String jmf_path = System.getProperty("jmf_jar","");
		if (jmf_path!="") {
			Out.printMe(Out.TRACE,"jmf.jar path added: "+jmf_path);
			classpath+=jmf_path+File.pathSeparator;;
		}
		else {
			JOptionPane.showMessageDialog(null, "Choose path to Java Media Framework jar (jmf.jar)");
		}


		String additional_path = System.getProperty("additional_classpath","");
		if (additional_path!="") {
			Out.printMe(Out.TRACE,"Additional classpath added: "+additional_path);
			classpath+=additional_path;
			Out.printMe(Out.TRACE,"Classpath is: "+classpath);

		}

		//classpath+=			root+File.separator+props.getProperty("mhp",".")+File.pathSeparator;
		//classpath+=			root+File.separator+props.getProperty("javatv",".")+File.pathSeparator;
		//classpath+=			root+File.separator+props.getProperty("jmf",".")+File.pathSeparator;

		//classpath+=			props.getProperty("absolute",".")+File.pathSeparator;

		classpath = classpath.trim();

		//System.out.println(classpath);


		File policyFile = new File("policy"+File.separator+orgid+"."+appid+".policy");
		writePolicyFile(policyFile);

		String security1 = "-Djava.security.manager";
		String security2 = "-Djava.security.policy="+policyFile.getAbsolutePath();

        File file = new File(path + System.getProperty("file.separator")+"");

        String args[] = {
            cmd, security1, security2, "-classpath", classpath, classfile, root, name, orgid, appid, root
        };

		for (int i=0;i<args.length;i++) {
			System.out.println("args["+i+"]: "+args[i]);
		}
/*
		for (int i=0;i<args.length;i++) {
			System.out.println(args[i]);
		}
*/
        try {
        	exception = null;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(args, null, file);
        }
        catch(Exception e) {
            exception = e;
            System.out.println(e);
        }
    }

    public static Exception getException() {
    	return exception;
    }

	public static Properties loadProperties(String filename) {
		Properties p = new Properties();
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(filename);
			try {	p.load(fis);	}
			catch (IOException e) {
				System.out.println(e.toString());
				}
			}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"Error while loading properties file >"+filename+"< "+e.toString());
			}
		System.out.println("Properties file >"+filename+"< loaded.");
		return p;
	}


	private static void writePolicyFile(File file) {
		String template = "";
		BufferedReader reader = null;
		BufferedWriter writer = null;

		try {
			String line = "";
			reader = new BufferedReader(new FileReader(new File("policy"+File.separator+"template.policy")));
			writer = new BufferedWriter(new FileWriter(file));
			while ((line=reader.readLine())!=null) {
				//template+=line+"\n";
				writer.write(line);
			}
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,e.toString());
		}
		try {
			writer.close();
			reader.close();
		}
		catch (Exception e2) { }

	}

}