package org.openmhp.system;

import java.awt.*;
import java.net.URL;
import java.io.*;
import org.openmhp.util.*;

/**
*
* Component for background image.
*
*
* @author tejopa
* @date 12.3.2004
* @status fully implemented
* @module internal
*/
public class StillImage extends Component{

    private String imageUrl;
    private Image image;

    public StillImage(String imageUrl){
    	image = loadImage(this,imageUrl);
		setSize(720,576);
    }

	public void update(Graphics g) {
		System.out.println("update");	
	}

    public void paint(Graphics g){
        if(image != null){
        	//System.out.println("Painting stillimage!!");
            g.drawImage(image, 0, 0, getWidth(), getHeight(), this);
        }
        else {
            Out.printMe(Out.ERROR,"not Painting stillimage!!");
    	}
    }
    
	public Image loadImage(Component c, String filename) {
			Image img = null;
			MediaTracker mediaTracker = null;
			if (img==null) {
				try	{
					System.out.println("Loading image " + filename);
					
					if (mediaTracker==null) {
						mediaTracker = new MediaTracker(this);
					}
					img = Toolkit.getDefaultToolkit().getImage(filename);
					if (img!=null) {
	            		mediaTracker.addImage(img, 0);
						mediaTracker.waitForAll();
					}else{
						System.out.println("Unable to load " + filename);
					}

				}	catch(Exception e) {  
					System.out.println(e.toString());
				}
	      	} 
		System.out.println("Loaded image " + filename+" "+img.getWidth(null)+"x"+img.getHeight(null)+" "+img.toString());
		return img;
	} // loadImage
        
}
