package org.openmhp.system;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.zip.*;

import org.openmhp.util.Out;

/**
* Classloader for xlets
*
* @author tejopa
* @date 11.11.2003
* @date 17.1.2005 added loading class files from jars
* TODO combine with DVBCLassLoader, perhaps?
*/
public class XletLoader extends ClassLoader {

	private URL[] urls;
	private Hashtable allowedClasses;

   	private Hashtable zipEntrySizes =new Hashtable();
   	private Hashtable zipFiles =new Hashtable();

	private boolean output = true;

	public XletLoader(URL[] list_of_urls ) {
		urls = list_of_urls;
		allowedClasses = new Hashtable();
		try {
			File cf = new File(System.getProperty("base_dir")+File.separator+System.getProperty("allowed_classes"));
			if (cf.exists()) {
				BufferedReader br = new BufferedReader(new FileReader(cf));
				String line = "";
				try {
					while ( (line = br.readLine()) != "") {
						allowedClasses.put(line.trim(),new Boolean(true));
					}
				}
				catch (Exception e) {
					//System.out.println("loading allowed classes: "+e.toString());
				}
			}
			else {
				Out.printMe(Out.ERROR,"allowed classes file not found!" + System.getProperty("base_dir")+File.separator+System.getProperty("allowed_classes"));
			}
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,e.toString());
		}
	}

	public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
		if (output) {
			System.out.println("<MHP RE> [loading class]: "+name);
		}

		if (name.indexOf("java.a")!=-1) {
			Boolean result = null;
			if ( (result = (Boolean)(allowedClasses.get(name))) != null) {		}
			else {
				Out.error(this,"Class "+name+" is not allowed in MHP");
			}
		} else {		}

//		if (name.indexOf("net")!=-1) {
//			Out.error(this,"REMOVE Class "+name+".");
//		}

		Class class_to_load = null;


		// check if already loaded
		class_to_load = findLoadedClass(name);
		// class was found, return it
		if (class_to_load!=null) {
			//System.out.println("[found from loaded class]");
			return class_to_load;
		}
		else {
			//System.out.println("not found from loadedClasses");
		}
		// this is reached only if class was not found
		try {
			URL url = null;
			ByteArrayOutputStream baos = new ByteArrayOutputStream();


			for (int i=0;i<urls.length;i++) {
				// if class is found, do not enter try
				if (class_to_load==null) {
					String filename = name;
					filename = filename.replace('.','/');
					url = urls[i];

					filename = url.toString()+filename+".class";
					//System.out.println("<<"+filename+">>");
					url = new URL(filename);
					try {
						InputStream is = url.openStream();
						// collect bytes to vector
						int b = -1;
						while ( (b = is.read()) != -1 ) {
							baos.write(b);
						}
						is.close();
						// create bytearray
						byte[] byte_array = baos.toByteArray();

						// try to define bytearray as a class
						class_to_load = defineClass(name, byte_array, 0, byte_array.length);
					}
					catch (FileNotFoundException u) {
						//System.out.println("class "+name+" not found from urls.");
						}
					catch (Exception u2) {
						Out.printMe(Out.ERROR,u2.toString());
					}
				} // if
			}



			if (class_to_load==null) {

					//System.out.println("finding from jar: "+name.replace('.','/')+".class");
					// we should have all files from jars in the hashtable, see if the class is there
					try {

						byte[] b = (byte[])zipFiles.get(name.replace('.','/')+".class");

						if (b!=null) {
							class_to_load = defineClass(name.replace('/','.'), b, 0, b.length);
							//System.out.println(name+" was found!");
						}
						else {
							//System.out.println(name+" was NOT found!");
						}
					}
					catch (Exception u) {
						Out.printMe(Out.ERROR,u.toString());
					}

			}


		}
		catch (Exception e) { Out.printMe(Out.ERROR,e.toString()); }


		if (class_to_load==null) {
			try {
				class_to_load = findSystemClass(name);
			}
			catch (Exception e) {
			//	System.out.println("not in system");
			}

			//if (class_to_load!=null) System.out.println("Found class "+name+" from system!");

		}

		if (class_to_load==null) {
			Out.error(this,"could not find class "+name);
			throw new ClassNotFoundException("Class "+name+" was not found from given urls or system.");
		}

		// try to resolve class, if needed
		if ((class_to_load!=null)&&(resolve)) {
			resolveClass(class_to_load);
		}


		return class_to_load;
	}

	public void addJars(URL[] urs) {
		// see if there are zip or jar files in the urls
				for (int i=0;i<urs.length;i++) {
					URL url = urs[i];
					String urls = url.getFile();

					if (urls.indexOf(".jar")!=-1) {
						// open jar
				      try {

				        // find the content lengths.
						ZipFile zipfile = new ZipFile(urls);
						Enumeration e = zipfile.entries();
						while (e.hasMoreElements()) {
				              ZipEntry zipentry = (ZipEntry)e.nextElement();
				              zipEntrySizes.put(zipentry.getName(),new Integer((int)zipentry.getSize()));
				        }
						zipfile.close();

							// read files.
							FileInputStream fis = new FileInputStream(urls);
							BufferedInputStream bis = new BufferedInputStream(fis);
							ZipInputStream zis = new ZipInputStream(bis);
							ZipEntry zipentry = null;

							while ((zipentry=zis.getNextEntry())!=null) {
								if (zipentry.isDirectory()) {
						                // just skip
						                continue;
						        }

						        // find out size
								int entrysize = (int)zipentry.getSize();
								if (entrysize==-1) {
									entrysize = ((Integer)zipEntrySizes.get(zipentry.getName())).intValue();
								}

								byte[] bytes = new byte[(int)entrysize];
								zis.read(bytes,0,(int)entrysize);
						        zipFiles.put(zipentry.getName(),bytes);
						        //System.out.println(zipentry.getName());
							}
						} catch (NullPointerException e) {
				          Out.printMe(Out.TRACE,"done.");
						} catch (FileNotFoundException e) {
				          e.printStackTrace();
						} catch (IOException e) {
				          e.printStackTrace();
						}


					}
				}
	}

	public Class loadClass(String s) {
		try {
			return loadClass(s,true);
		}
		catch (Exception e) { Out.printMe(Out.ERROR,e.toString()); return null; }
	}

	public void setOutput(boolean b) {
		output = b;
	}

}