package org.dvb.media;

import javax.media.Time;

import java.io.IOException;

import org.openmhp.util.*;

/**
* @author tejopa
* @date 7.3.2004
* @date 1.12.2004 docs
* @status not implemented
* @module internal, media
* @HOME


Description
This class allows to create a source for a JMF player to be able to feed the decoder progressively with
parts of a clip (e.g. I or P MPEG-2 frame) according to the drip-fed mode format de?ned in the MHP
content format chapter.
To start using the drip-feed mode, the application needs to instantiate a player representing a MPEG-2
video decoder and have its source be a DripFeedDataSource instance.
A DripFeedDataSource instance can be obtained by calling the default constructor of the class.
A player that will be bound to a MPEG-2 video decoder (when realized) can be created with the following
special URL (locator): "dripfeed://". It is also possible to use a decoder that was instantiated to play a
broadcast MPEG-2 stream.
After having the DripFeedDataSource connected to a Player representing a MPEG-2 video decoder, the
following rules applies:
- If the feed method is called when the player is in the "prefetched" state the image will be stored so that
when the player goes in the "started" state it will be automatically displayed.
- If the feed method is called when the player is in the "started" mode, the frame shall be displayed
immediately. In particular it is not required to feed a second frame to the decoder to display the ?rst
frame.
- If the feed method is called when the player is in any other state (or if the DripFeedDataSource is not
connected to a player), it will be ignored by the platform implementation.


*/
public class DripFeedDataSource extends javax.media.protocol.DataSource {

	private byte[] feed;
	private String contentType = "JPEG";

	/**
	Constructor. A call to the constructor will throw a security exception if the application is not granted
	the right to use this mode.
	*/
	public DripFeedDataSource() {
		Out.printMe(Out.TRACE);
	}

	public void feed(byte[] clip_part) {
		Out.printMe(Out.TRACE);
		feed = clip_part;
	}

	public java.lang.String getContentType() {
		Out.printMe(Out.TRACE,contentType);
		return contentType;
	}

	public void connect() throws IOException {
		Out.printMe(Out.TRACE);
	}

	public void disconnect() {
		Out.printMe(Out.TRACE);
	}

	public void start() throws IOException {
		Out.printMe(Out.TRACE);
	}

	public void stop() throws IOException {
		Out.printMe(Out.TRACE);
	}

	public  Time getDuration() {
		Out.printMe(Out.TRACE);
		return DURATION_UNKNOWN;
	};

	public Object[] getControls() {
		Out.printMe(Out.TRACE);
		return null;
	}

	public Object getControl(String controlType) {
		Out.printMe(Out.TRACE);
		return null;
	}

}

