package org.dvb.media;

import javax.media.Control;
import org.havi.ui.HScreenRectangle;

/**
* @author tejopa
* @date 13.2.2004
* @date 1.12.2004 docs
* @status fully implemented
* @module internal

All Known Subinterfaces:
BackgroundVideoPresentationControl
All Superinterfaces:
javax.media.Control
Description
A control to support setting and querying the video presentation.
Note: For a component-based player the scaling and positioning of the video is done by manipulating the
corresponding AWT component. The VideoPresentationControl only allows for the setting of the clipping
region.
Note: If the hardware supports the positioning of interlaced video on even lines only (when counting from
0), then a component-based player is allowed to position the top of the video one line below where it
should be.
For a background player there is the BackgroundVideoPresentationControl that allows for the setting of
the clipping region, the position and the scaling of the video in one atomic action.

*/
public interface VideoPresentationControl extends Control {

	public static final byte POS_CAP_FULL = 0;
	public static final byte POS_CAP_FULL_IF_ENTIRE_VIDEO_ON_SCREEN = 1;
	public static final byte POS_CAP_FULL_EVEN_LINES = 3;
	public static final byte POS_CAP_FULL_EVEN_LINES_IF_ENTIRE_VIDEO_ON_SCREEN = 4;
	public static final byte POS_CAP_OTHER = -1;

	public abstract HScreenRectangle getActiveVideoArea();

	public abstract HScreenRectangle getActiveVideoAreaOnScreen();

	public abstract java.awt.Rectangle getClipRegion();

	public abstract float[] getHorizontalScalingFactors();

	public abstract java.awt.Dimension getInputVideoSize();

	public byte getPositioningCapability();

	public abstract HScreenRectangle getTotalVideoArea();

	public abstract HScreenRectangle getTotalVideoAreaOnScreen();

	public abstract float[] getVerticalScalingFactors();

	public abstract java.awt.Dimension getVideoSize();

	public abstract java.awt.Rectangle setClipRegion(java.awt.Rectangle clipRect);

	public abstract float[] supportsArbitraryHorizontalScaling();

	public abstract float[] supportsArbitraryVerticalScaling();

	public abstract boolean supportsClipping();



}
