package org.dvb.ui;

import java.awt.Color;

/**
 * @author tejopa
 * @date 7.3.2004 (checked)
 * @date 10.3.2004 (fixed)
 * @date 22.6.2004 fixed constructor to return opaque colors
 * @status partially implemented
 * @module internal
 * @TODO extending AlphaColor results in black components... check this
 * @HOME
 */
public class DVBColor extends Color { //javax.tv.graphics.AlphaColor {
    
    public DVBColor(java.awt.Color c){
        super(c.getRed(),c.getGreen(),c.getBlue());
    }
    
    public DVBColor(float r, float g, float b, float a){
        super(r,g,b,a);
    }
    
    public DVBColor(int rgba, boolean hasalpha)	{
        super(rgba,hasalpha);
    }
    
    public DVBColor(int r, int g, int b, int a){
        super(r,g,b,a);
    }
    
    public java.awt.Color brighter(){
        return super.brighter();
    }
    
    public java.awt.Color darker(){
        return super.darker();
    }
    
    public boolean equals(java.lang.Object obj)	{
        boolean result = false;
        if(obj != null && obj instanceof DVBColor){
            DVBColor other = (DVBColor)obj;
            if (other.getRed()!=getRed()) {
                return false;
            }
            if (other.getGreen()!=getGreen()) {
                return false;
            }
            if (other.getBlue()!=getBlue()) {
                return false;
            }
            if (other.getAlpha()!=getAlpha()) {
                return false;
            }
            result = true;
        }
        return result;
    }
    
    public int getAlpha(){
        return super.getAlpha();
    }
    
    public int getRGB(){
        return super.getRGB();
    }
    
    public java.lang.String toString(){
        return "DVBColor: "+getRed()+","+getGreen()+","+getBlue()+","+getAlpha();
    }
}
