package org.havi.ui;

import org.openmhp.util.Out;

import java.awt.*;

/**
* @author tejopa
* @date 7.3.2004
* @status partially implemented
* @module internal, graphics
* HOME
*/
public class HGraphicLook implements HLook{

	private Insets currentInsets = new Insets(0,0,0,0);

    public HGraphicLook() { }

    public void showLook(Graphics g, HVisible hvisible, int state){
		Out.printMe(Out.FIXME);

        Dimension d = hvisible.getSize();
        if (hvisible.getBackgroundMode()==HVisible.BACKGROUND_FILL){
            Color c = hvisible.getBackground();
            if(c != null){
                g.setColor(c);
                g.fillRect(0, 0, d.width, d.height);
            }
        }

        Image image = hvisible.getGraphicContent(state);

        if (image!=null) {

            int x = 0;
			int ha = hvisible.getHorizontalAlignment();
            int iw  = image.getWidth(hvisible);
            int w = hvisible.getWidth();

            if(ha==HVisible.HALIGN_CENTER||ha==HVisible.HALIGN_JUSTIFY){
                x = (w/2)-(iw/2);
            }
            if (ha==HVisible.HALIGN_LEFT){
                x = 0;
            }
            if (ha==HVisible.HALIGN_RIGHT){
                x = w-iw;
            }



            int y = 0;
            int va = hvisible.getVerticalAlignment();
            int h = hvisible.getHeight();
            int ih = image.getHeight(hvisible);

            if (va==HVisible.VALIGN_CENTER||va==HVisible.HALIGN_JUSTIFY) {
                y = (h/2)-(ih/2);
            }
            if (va==HVisible.VALIGN_TOP){
                y = 0;
            }
            if (va==HVisible.VALIGN_BOTTOM){
                y = h-ih;
            }

            g.drawImage(image, x, y, null);

        }
    }

    public void widgetChanged (HVisible hvisible, HChangeData[] changes){
		hvisible.repaint();
    }

    public Dimension getMinimumSize(HVisible hvisible){
        return hvisible.getMinimumSize();
    }

    public Dimension getPreferredSize(HVisible hvisible){
        return hvisible.getPreferredSize();
    }

    public Dimension getMaximumSize(HVisible hvisible){
        return hvisible.getMaximumSize();
    }

    public boolean isOpaque(HVisible hvisible){
        return hvisible.isOpaque();
    }

    public Insets getInsets(HVisible hvisible){
		Out.printMe(Out.TODO);
        return currentInsets;
    }

}







