package org.havi.ui;

import java.awt.*;
import org.openmhp.util.Out;

/**
* @author tejopa
* @date 6.3.2004
* @date 6.4.2004 fully implemented
* @status fully implemented
* @module internal
* @tested no
*/
public class HStaticIcon extends HVisible implements HNoInputPreferred{

    private HLook currentLook = null;

    private static HLook defaultHLook = new HGraphicLook();

    public HStaticIcon() { }

    public HStaticIcon(Image imageNormal, int x, int y, int width, int height){
        super(defaultHLook, 0, 0, 0, 0);
		Out.printMe(Out.TRACE);
		setDefaults();
		setLocation(x,y);
		setSize(width,height);
		setGraphicContent(imageNormal, HVisible.NORMAL_STATE);
	}

    public HStaticIcon(Image imageNormal){
		Out.printMe(Out.TRACE);
        setDefaults();
        setGraphicContent(imageNormal, HVisible.NORMAL_STATE);
    }

	/** 
	* Sets default values for this object.
	* @author tejopa
	* @date 6.4.2004
	*/
	private void setDefaults() {
		setLocation(0,0);
		setSize(0,0);
		setGraphicContent(null,NORMAL_STATE);
		try { setMatte(null); } catch (Exception e) { Out.printMe(Out.ERROR,e.toString()); }
		setTextLayoutManager(new HDefaultTextLayoutManager());
		setBackgroundMode(NO_BACKGROUND_FILL);
		setDefaultSize(NO_DEFAULT_SIZE);
		setHorizontalAlignment(HALIGN_CENTER);
		setVerticalAlignment(VALIGN_CENTER);		
		setResizeMode(RESIZE_NONE);
		setDefaultLook(new HGraphicLook());
		try { setLook(getDefaultLook()); } catch (Exception e) { Out.printMe(Out.ERROR,e.toString()); }
	}

    public void setLook(HLook look) throws HInvalidLookException{
		Out.printMe(Out.TRACE);
        currentLook = look;
    }

    public static void setDefaultLook(HGraphicLook look){
		Out.printMe(Out.TRACE);
        defaultHLook = look;
    }

    public static HGraphicLook getDefaultLook(){
		Out.printMe(Out.TRACE);
        return (HGraphicLook)defaultHLook;
    }
}
