package org.openmhp.adaptation.graphics;


import java.awt.*;
import java.awt.image.*;

/**
* @author tejopa
* @date 26.10.2004
*/
public interface ApplicationImageProvider {

	/**
	* @return Image from the application's current state
	*/
	public Image getApplicationImage();

	/**
	* @return BufferedImage from the application's current state
	*/
	public BufferedImage getApplicationBufferedImage();

	/**
	* @param quality The encoding quality (worst 0.0f - 1.0f best).
	* @return JPEG encoded image from the application's current state
	*/
	public byte[] getApplicationImage(float quality);

}