package org.openmhp.media;

import org.dvb.media.*;
import org.havi.ui.*;
import java.awt.*;

import org.openmhp.util.Out;

/*
* 15.9.2004 implemented setClipRegion and getClipRegion tejopa
*
*/

public class BackgroundVideoPresentationControlImpl implements BackgroundVideoPresentationControl {
	
	static BackgroundVideoPresentationControlImpl instance;
	VideoTransformation videoTransformation = new VideoTransformation();
	Rectangle clipRegion;
	
	Dimension FULLSCREEN = new Dimension(720,576);
	
	protected BackgroundVideoPresentationControlImpl() { }
	
	public static BackgroundVideoPresentationControlImpl getInstance() {
		if (instance==null) instance = new BackgroundVideoPresentationControlImpl();
		return instance;	
	}
	
	public boolean setVideoTransformation(VideoTransformation t) {
		Out.printMe(Out.TRACE,t.toString());
		videoTransformation = t;
		return true;
	}
	
	public VideoTransformation getVideoTransformation() {
		if (videoTransformation==null) {
			Out.printMe(Out.TRACE,"no VideoTransformation set");
		}
		else {
		//	Out.printMe(Out.TRACE,videoTransformation.toString());
		}
		return videoTransformation;
	}
	
	public VideoTransformation getClosestMatch(VideoTransformation t) {
		Out.printMe(Out.TRACE);
		return t;	
	}

	public java.awt.Dimension getInputVideoSize() {
		Out.printMe(Out.TRACE,FULLSCREEN.toString());
		return FULLSCREEN;
	 }

	public  java.awt.Dimension getVideoSize() {
		Out.printMe(Out.TRACE,videoTransformation.getClipRegion().getSize().toString());
		return videoTransformation.getClipRegion().getSize();
 	}

	public  HScreenRectangle getActiveVideoArea() {
		Out.printMe(Out.TRACE);
	 	return new HScreenRectangle(0,0,720,576);
 	}
	
	public  HScreenRectangle getActiveVideoAreaOnScreen() {
		Out.printMe(Out.TRACE);
		return new HScreenRectangle(0,0,720,576);
 	}	
	
	public  HScreenRectangle getTotalVideoArea() {
		Out.println(new Object(),"BackgroundVideoPresentationControlImpl getTotalVideoArea");
		return new HScreenRectangle(0,0,720,576);
 	}
		
	public  HScreenRectangle getTotalVideoAreaOnScreen() {
		Out.println(new Object(),"BackgroundVideoPresentationControlImpl getTotalVideoAreaOnScreen");
		return new HScreenRectangle(0,0,720,576);
 	}
	
	public  boolean supportsClipping() {
		Out.println(new Object(),"BackgroundVideoPresentationControlImpl supportsClipping");
 		return false;
 	}

	public java.awt.Rectangle setClipRegion(java.awt.Rectangle clipRect) {
		Out.printMe(Out.TRACE);
		clipRegion = clipRect;
		return clipRegion;
 	}

	public  java.awt.Rectangle getClipRegion() {
		Out.printMe(Out.TRACE);
		return clipRegion;
 	}
	
	public  float[] supportsArbitraryHorizontalScaling() {
		Out.println(new Object(),"BackgroundVideoPresentationControlImpl supportsArbitraryHorizontalScaling");
 		return null;
 	}
		
	public  float[] supportsArbitraryVerticalScaling() {
		Out.println(new Object(),"BackgroundVideoPresentationControlImpl supportsArbitraryVerticalScaling");
 		return null;
 	}
	
	public  float[] getHorizontalScalingFactors() { 		
		Out.println(new Object(),"BackgroundVideoPresentationControlImpl getHorizontalScalingFactors");
		return null;
 	}
	
	public  float[] getVerticalScalingFactors() { 
		Out.println(new Object(),"BackgroundVideoPresentationControlImpl getVerticalScalingFactors");
		return null;
	}
	
	public static final byte POS_CAP_FULL = 0;
	
	public static final byte POS_CAP_FULL_IF_ENTIRE_VIDEO_ON_SCREEN = 1;
	
	public static final byte POS_CAP_FULL_EVEN_LINES = 3;
	
	public static final byte POS_CAP_FULL_EVEN_LINES_IF_ENTIRE_VIDEO_ON_SCREEN = 4;
	
	public static final byte POS_CAP_OTHER = -1;
	
	public byte getPositioningCapability() { 
		Out.println(new Object(),"BackgroundVideoPresentationControlImpl getPositioningCapability");
		return 0;
	}
	
    public Component getControlComponent() {
		Out.println(new Object(),"BackgroundVideoPresentationControlImpl getControlComponent");
		return null;
	}

}