package org.openmhp.si;

import org.dvb.si.*;

import java.util.Date;
import java.util.Vector;
import org.davic.net.dvb.DvbLocator;

import org.davic.mpeg.TransportStream;

import org.openmhp.util.*;

/**
* @author tejopa
* @date 25.11.2003
* @status partially implemented
* @module internal, si
*/
public class SIServiceImpl implements SIService {

	DvbLocator dvblocator = null;
	int networkID = 0;
	int transportID = 0;
	int serviceID = 0;
	short siType = 0;
	String name = "unknown";
	String providerName =" unknown provider name";
	static RequestHandler requestHandler;


	public SIServiceImpl() {
		super();
		Out.printMe(Out.TRACE);			
	}

	public SIServiceImpl(DvbLocator l, int nid, int tsid, int sid, short sit, String n, String pn) {
		super();
		Out.printMe(Out.TRACE);	
		dvblocator = l;
		networkID = nid;
		transportID = tsid;
		serviceID = sid;
		siType = sit;
		name = n;
		providerName = pn;
		if (requestHandler==null) {
			requestHandler = new RequestHandler();	
		}
	}

    public DvbLocator getDvbLocator() { 
		Out.printMe(Out.TRACE,dvblocator.toString());	
		return dvblocator;
    }

    public int getOriginalNetworkID() {
		Out.printMe(Out.TRACE);	
    	return networkID;
    }

    public int getTransportStreamID() {
		Out.printMe(Out.TRACE);	
		return transportID;
    }

    public int getServiceID() {
		Out.printMe(Out.TRACE);	
    	return serviceID;
    }

    public short getSIServiceType() {
		Out.printMe(Out.TRACE);	
    	return siType;
    }

    public String getName() {
		Out.printMe(Out.TRACE);	
    	return name;
    }

    public String getShortServiceName() {
		Out.printMe(Out.TRACE);	
    	return "no short service name FIXME";
    }

    public String getProviderName() {
		Out.printMe(Out.TRACE);	
    	return providerName;
    }

    public String getShortProviderName() {
		Out.printMe(Out.TRACE);	
		return "no short provder name FIXME";
    }

    public boolean getEITScheduleFlag() {
		Out.printMe(Out.TODO);	
		return false;    	
    }
    
    public boolean getEITPresentFollowingFlag() {
		Out.printMe(Out.TODO);	
  	   	return false;
    }

    public byte getRunningStatus()  {
		Out.printMe(Out.FIXME);	
    	return 1;
    }

    public boolean getFreeCAMode() {
		Out.printMe(Out.TODO);	
    	return true;
    }

    public SIRequest retrievePresentSIEvent(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException {
        Out.printMe(Out.TRACE);
        SIRequest sir = new SIRequestImpl();
       	requestHandler.addRequest(obj,sir,siretrievallistener,"retrievePresentSIEvent",dvblocator);    
		return sir;
    }
    
    public SIRequest retrieveFollowingSIEvent(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException {
        Out.printMe(Out.TRACE);
        SIRequest sir = new SIRequestImpl();
       	requestHandler.addRequest(obj,sir,siretrievallistener,"retrieveFollowingSIEvent",dvblocator);    
		return sir;
    }

    public SIRequest retrieveScheduledSIEvents(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[], Date date, Date date1) throws SIIllegalArgumentException, SIInvalidPeriodException {
		Out.printMe(Out.TODO);	
    	return null;
    }

    public SIRequest retrievePMTService(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException {
		Out.printMe(Out.TODO);	
    	return null;
    }

    public String[] getTextualServiceIdentifiers() {
		Out.printMe(Out.TODO);	
    	return null;
    }

	public String toString() {
		String result = "";
		result += "| "+dvblocator.toString();
		result += "| "+networkID;
		result += "| "+transportID;
		result += "| "+serviceID;
		result += "| "+siType;
		result += "| "+name;
		result += "| "+providerName;
		return result;	
	}



    public  SIRequest retrieveDescriptors(short word0, Object obj, SIRetrievalListener siretrievallistener) throws SIIllegalArgumentException  {
    	Out.printMe(Out.TODO);
    	return null;
    }

    public  SIRequest retrieveDescriptors(short word0, Object obj, SIRetrievalListener siretrievallistener, short aword0[]) throws SIIllegalArgumentException  {
    	Out.printMe(Out.TODO);
	    return null;
    }

    public  short[] getDescriptorTags() {
    	Out.printMe(Out.TODO);
		 return null; 
    }

    public  SIDatabase getSIDatabase() {
    	Out.printMe(Out.TODO);
		return null;
    }

    public  Date getUpdateTime() {
    	Out.printMe(Out.TODO);
		return null;
    }

    public  boolean fromActual() {
    	Out.printMe(Out.TODO);
		return false;
    }

    public  TransportStream getDataSource() {
    	Out.printMe(Out.TODO);
		return null;
    }



	static class RequestHandler implements Runnable {
		Thread handlerThread;
		LinkedList requests;
		LinkedList listeners;
		LinkedList appDatas;
		LinkedList requestIDs;
		LinkedList objects;
				
		public RequestHandler() {
			requests = new LinkedList();
			listeners = new LinkedList();
			appDatas = new LinkedList();
			requestIDs = new LinkedList();
			objects = new LinkedList();
			
			handlerThread = new Thread(this);
			handlerThread.start();
			Out.printMe(Out.TRACE,"org.openmhp.si.SIRequestHandler thread started");
		}	
		
		public void run() {
			while (true) {
				try {
					handlerThread.sleep(500);
					handleRequest();
				}
				catch (Exception e) { }
			}	
		}

		public void addRequest(Object a, SIRequest r, SIRetrievalListener l, String id) {
			Out.printMe(Out.TRACE,"++++++++++++++++++++++++++ SIRequest added : "+id);
			appDatas.add(a);
			requests.add(r);
			listeners.add(l);	
			requestIDs.add(id);
			objects.add(new String("none"));
		}

		public void addRequest(Object a, SIRequest r, SIRetrievalListener l, String id, Object object) {
			Out.printMe(Out.TRACE,"++++++++++++++++++++++++++ SIRequest added : "+id);
			appDatas.add(a);
			requests.add(r);
			listeners.add(l);	
			requestIDs.add(id);
			objects.add(object);
		}

		private void handleRequest() {
			if (requests.size()>0) {
				Object appData = appDatas.removeFirst();
				SIRequest request = (SIRequest)requests.removeFirst();	
				SIRetrievalListener listener = (SIRetrievalListener)listeners.removeFirst();
				String id = (String)requestIDs.removeFirst();
				Object object = (Object)objects.removeFirst();
				

				if (id.equals("retrievePresentSIEvent")) {
					// set filter
					EITParser parser = EITParser.getInstance();
					SIEventImpl event = new SIEventImpl((DvbLocator)object);
					parser.addEITListener(new EITListener(event,listener,request,appData,0x4E,0)); // present table id 0x4E, section number 0
					/*
        			Vector v = new Vector();
        			v.add((SIEvent)event);
        			org.openmhp.si.SIIteratorImpl iter = new org.openmhp.si.SIIteratorImpl(v.elements());
					Out.printMe(Out.TRACE,"## request handled ## retrievePresentSIEvent");
					listener.postRetrievalEvent(new SISuccessfulRetrieveEvent(appData,request,iter));
					*/
					return;
				}		
					if (id.equals("retrieveFollowingSIEvent")) {
					// set filter
					EITParser parser = EITParser.getInstance();
					SIEventImpl event = new SIEventImpl((DvbLocator)object);
					parser.addEITListener(new EITListener(event,listener,request,appData,0x4E,1)); // present table id 0x4E, section number 1
					return;
				}
	
	
				listener.postRetrievalEvent(new SITableNotFoundEvent(appData,request));
        		Out.printMe(Out.TRACE,"## request handled WITH ERROR ## ERROR ");
        	}			
		}
	}





}