package org.openmhp.system;

import java.awt.*;
import javax.tv.media.AWTVideoSize;
import javax.tv.media.AWTVideoSizeControl;

import org.openmhp.util.Out;

/**
* @author tejopa
* @date 12.3.2004
* @status partially implemented
* @module internal, video, graphics
* TODO map through adaptation layer
*/
public class AWTVideoSizeControlImpl implements AWTVideoSizeControl {

    private static AWTVideoSizeControlImpl instance;
    private AWTVideoSize defaultSize;
    private AWTVideoSize currentSize;
	
	/*
	Reports the AWTVideoSize at which the Player is currently operating.
	Returns:
	A copy of the JMF Player's current video size, in the AWT coordinate space.	
	*/
    public AWTVideoSize getSize() {
        return currentSize;
    }

	/*
	Reports the default AWTVideoSize for this control. For the background video plane, this will be the size that the video would be presented at if no program had manipulated the video size.
	Returns:
	The default AWTVideoSize.
	*/
    public AWTVideoSize getDefaultSize() {
        return defaultSize;
    }

	/*
	Reports the size of the source video, in the screen's coordinate system.
	Returns:
	The size of the source video.
	*/
    public Dimension getSourceVideoSize() {
        Rectangle s = currentSize.getSource();
        Dimension result = new Dimension(s.width,s.height);
        return result;
    }

	/*
	Sets the video size. If the size provided cannot be supported by the underlying platform, this method does nothing and returns false.
	Parameters:
	sz - The desired video size, in the AWT coordinate space.
	Returns:
	true if the size was successfully changed; false if the platform is incapable of supporting the given size.
	*/
    public boolean setSize(AWTVideoSize newsize) {
    	currentSize = newsize;
		Out.printMe(Out.TODO,"returns always true");
        return true;
    }

	/*
	Reports how closely the underlying platform can approximate a desired video size. If the underlying platform cannot support the given size, this method gives the closest approximation that the platform is capable of.
	Parameters:
	sz - The desired video size.
	Returns:
	The actual size that the platform would be able to set.
	*/
    public AWTVideoSize checkSize(AWTVideoSize awtvideosize) {
        return currentSize;
    }

	/*
	Get the Component associated with this Control object. For example, this method might
	return a slider for volume control or a panel containing radio buttons for CODEC control.
	The getControlComponent method can return null if there is no
	GUI control for this Control.
	*/
	public Component getControlComponent() {
		//No GUI component to return
		return null;
	}

    public static AWTVideoSizeControlImpl getInstance() {
        if(instance== null) {
            instance= new AWTVideoSizeControlImpl();
        }
        return instance;
    }

    private AWTVideoSizeControlImpl()    {
 		defaultSize = new AWTVideoSize(new Rectangle(0, 0, 720, 576), new Rectangle(0, 0, 720, 576));
        currentSize = defaultSize;
    }


}