package org.openmhp.util;

import java.io.*;
import java.util.*;
import org.davic.net.dvb.*;
import org.openmhp.si.*;
import org.dvb.si.*;

/**
* Class for parsing DVSNoops EIT capture
*
* @author tejopa
* @date 13.5.2004
* @status partially implemented
* @module internal
*/
public class EITParser implements Runnable {

	BufferedReader buffer;
	Thread thread;
	boolean stopRequested = false;
	boolean paused = false;
	boolean parsing = false;
	long time = 0;
	Clock clock;

	
		
	LinkedList eitListeners;

		
	private static EITParser instance;
	
	protected EITParser(String filename) {
		try {
			buffer = new BufferedReader(new FileReader(new File(filename))); 	
		}
		catch (Exception e) {
			Out.printMe(Out.ERROR,"Could not find EIT data file");	
		}
		thread = new Thread(this);
	}

	public static EITParser getInstance(String file) {
		if (instance==null) {
			instance = new EITParser(file);
			}	
		return instance;
	}

	public static EITParser getInstance() {
		return instance;	
	}

	public void start() {
		thread.start();
		clock = new Clock();
		clock.start();
		time = System.currentTimeMillis();	
	}
	
	public void stop() {
		stopRequested = true;	
	}


	public void run() {
		while (!stopRequested) {
			long time = 10;

			if (!parsing) {
				parsePacket();			
			}
			else {
				time = 10;	
			}
			try { thread.sleep(time); } catch (Exception e) { }
		}
	}
	

	
	public void addEITListener(EITListener l) {
		if (eitListeners==null) {
			eitListeners = new LinkedList();
		}
		eitListeners.add(l);	
	}
	
	
	private void checkListeners(EITTable table) {
		// IF NO LISTENERS REGISTERED
		if (eitListeners!=null) {
			// LOOP LISTENERS, IF ANY
			//System.out.println(eitListeners.size());
			int i = 0;
			while (i<eitListeners.size()) {
				EITListener l = (EITListener)eitListeners.get(i);				
				// TEST IF INTERESTED LISTENER
				boolean interested = true;
				if (table.section_number!=l.section_number) interested = false;
				if (table.table_id!=l.table_id) interested = false;
				if (table.ON_ID!=l.eventToFill.getOriginalNetworkID()) interested = false;
				if (table.TS_ID!=l.eventToFill.getTransportStreamID()) interested = false;
				if (table.S_ID!=l.eventToFill.getServiceID()) interested = false;
				if (interested) {
					eitListeners.remove(l);
					
					l.eventToFill.setEventName(table.event_name);
					l.eventToFill.setStartTime(table.start_time);
					l.eventToFill.setDuration(table.duration);
					
					System.out.println("INTERESTED LISTENER FOUND "+table.ON_ID+"."+table.TS_ID+"."+table.S_ID+" "+table.section_number+" "+table.table_id);	
					
        			Vector v = new Vector();
        			v.add((SIEvent)(l.eventToFill));
        			org.openmhp.si.SIIteratorImpl iter = new org.openmhp.si.SIIteratorImpl(v.elements());
					Out.printMe(Out.TRACE,"## request handled ##");
					l.siRetrievalListener.postRetrievalEvent(new SISuccessfulRetrieveEvent(l.appData,l.siRequest,iter));
					
				}
				else {
					i++;
				}
			}
		}	
	}
	
	public void parsePacket() {
		parsing = true;
		String line = "";
		boolean ready = false;
		int  S_ID = -1;
		int  TS_ID = -1;
		int  ON_ID = -1;
		int curr_table_id = -1;
		int curr_section_number = -1;
		try {
			while (!ready&(line = buffer.readLine())!=null) {
				//System.out.println(line);
				// FIND SECT PACKET START
				if (line.indexOf("SECT-Packet:")!=-1) {
				
					String timestring = buffer.readLine();
					StringTokenizer st = new StringTokenizer(timestring);
					st.nextToken(" "); // Time
					st.nextToken(" "); // received
					st.nextToken(" "); // DAY
					st.nextToken(" "); // DATE
					String hours = st.nextToken(":");
					String minutes = st.nextToken(":");
					String seconds = st.nextToken(".");
					
					//System.out.println(hours+"/"+minutes+"/"+seconds);
					//System.out.println(clock.getMediaTime());
					ready = true;
				}
			}
			ready = false;
			
			EITTable currEITTable = new EITTable();
			
			
			while (!ready&(line = buffer.readLine())!=null) {
				// FIND Table_ID
				if (line.indexOf("Table_ID")!=-1) {
					StringTokenizer st = new StringTokenizer(line);
					st.nextToken(" "); // "Table_ID:"
	 			 	curr_table_id = Integer.parseInt(st.nextToken(" "));
					currEITTable.table_id = curr_table_id;
					ready = true;
				}
			}

			line = findLine("Section_number");
			if (line!=null) {
				StringTokenizer st = new StringTokenizer(line);
				st.nextToken(" "); // "section_number:"
				curr_section_number = Integer.parseInt(st.nextToken(" "));
				currEITTable.section_number = curr_section_number;
			}
			
			//System.out.println(curr_table_id+" "+tableID+" "+curr_section_number+" "+sectionNumber);
			
			//if ((curr_table_id==tableID)&&(curr_section_number==sectionNumber)) {
				//System.out.println("IN");
				ready = false;
				while (!ready&(line = buffer.readLine())!=null) {
					// FIND SERVICE ID
					if (line.indexOf("Service_ID")!=-1) {
						StringTokenizer st = new StringTokenizer(line);
						st.nextToken(" "); // "Service_ID:"
						 S_ID = Integer.parseInt(st.nextToken(" "));
						currEITTable.S_ID = S_ID;
						ready = true;
					}
				}
				ready = false;
				while (!ready&(line = buffer.readLine())!=null) {
					// FIND Transport_stream_ID
					if (line.indexOf("Transport_stream_ID")!=-1) {
						StringTokenizer st = new StringTokenizer(line);
						st.nextToken(" "); // "Transport_stream_ID:"
						TS_ID = Integer.parseInt(st.nextToken(" "));
						currEITTable.TS_ID = TS_ID;
						ready = true;
					}
				}
				ready = false;
				while (!ready&(line = buffer.readLine())!=null) {
					// FIND Original_network_ID
					if (line.indexOf("Original_network_ID")!=-1) {
						StringTokenizer st = new StringTokenizer(line);
						st.nextToken(" "); // "Original_network_ID:"
						ON_ID = Integer.parseInt(st.nextToken(" "));
						currEITTable.ON_ID = ON_ID;
						ready = true;
					}
				}
				
				// START TIME
				ready = false;
				while (!ready&(line = buffer.readLine())!=null) {
					// FIND Original_network_ID
					if (line.indexOf("Start_time:")!=-1) {
						StringTokenizer st = new StringTokenizer(line);
						st.nextToken(" "); // "Original_network_ID:"
						String raw = st.nextToken(" ");
						try {
							Long start_time = Long.valueOf(raw.substring(2,raw.length()),16);
							currEITTable.start_time = new Date(start_time.longValue());
						}
						catch (Exception e) { System.out.println(e); }
						//currEITTable.start_time = event_name.trim();
						ready = true;
					}
				}
				
				// DURATION
				ready = false;
				while (!ready&(line = buffer.readLine())!=null) {
					// FIND Original_network_ID
					if (line.indexOf("Duration:")!=-1) {
						StringTokenizer st = new StringTokenizer(line);
						st.nextToken(" "); // "Original_network_ID:"
						String raw = st.nextToken(" ");
						try {
							Long duration = Long.valueOf(raw.substring(2,raw.length()),16);
							currEITTable.duration = duration.longValue();
							//System.out.println(duration.longValue());
						}
						catch (Exception e) { System.out.println(e); }
						//currEITTable.start_time = event_name.trim();
						ready = true;
					}
				}

				// EVENT NAME
				ready = false;
				while (!ready&(line = buffer.readLine())!=null) {
					// FIND Original_network_ID
					if (line.indexOf("Event_name:")!=-1) {
						StringTokenizer st = new StringTokenizer(line);
						st.nextToken("\""); // "Original_network_ID:"
						String event_name= st.nextToken("\"");
						currEITTable.event_name= event_name;
						ready = true;
					}
				}

				
				checkListeners(currEITTable);
				
				/*
				if (eventToFill!=null) {
					DvbLocator temp = new DvbLocator(ON_ID,TS_ID,S_ID);
					if (eventToFill.getDvbLocator().equals(temp)) {
						System.out.println("CORRECT TABLE FOUND");	
					
					
					}	
				}
				*/
	
			//} // was not the table we wanted
			//else {
			
			//}

		} catch (Exception e) {
			
		}
		parsing = false;	
	}

	private String findLine(String find_this) {
			String l = "";
			boolean r = false;
			try {
				while (!r&(l = buffer.readLine())!=null) {
					if (l.indexOf(find_this)!=-1) {
						r = true;
						return l;
					}
				}
			}
			catch (Exception e) { }
			return null;		
	}

	class Clock implements Runnable {
		Thread clockThread;
		long timebase = 0;
		long mediaTime = 0;
		public Clock() {	}
		
		public void start() {
			timebase = System.currentTimeMillis();
			clockThread = new Thread(this);
			clockThread.start();	
		}
		
		public void run() {
			while (!stopRequested) {
				try {
					clockThread.sleep(20);
					mediaTime = System.currentTimeMillis() - timebase;
				}
				catch (Exception e) { }
			}	
		}
		
		public long getMediaTime() {
			return mediaTime;	
		}	
	}



}