
package org.dvb.application.storage;

/** 
  * This interface supports creating new Service objects
  * representing stand-alone stored application services.
  * Services thus created shall appear in the list of services maintained by the 
  * SIManager until removed using <code>StoredApplicationService.remove</code> or some MHP
  * terminal specific mechanism. i.e. they shall be returned by <code>filterServices</code>
  * both when passed an instance of <code>ServiceTypeFilter</code> constructed with the type
  * <code>StoredApplicationService.STORED_APPLICATION_SERVICE</code> and when passed null to 
  * list all known services.
  * <p>  
  * This interface shall be implemented by the object returned from 
  * <code>javax.tv.service.SIManager.getInstance</code>
  * only in those MHP implementations which support stand-alone stored applications.
  *
  * @since MHP1.1
  */

public interface StoredServiceCreator {

    /** 
      * Requests the platform to create a new stored application
      * service.
      *
      * @return the stored application service created
      *
      * @param organisation_id the organisation_id of the organisation 
      *                        to whom this service belongs to
      * @param service_id unique identifier for this service within the 
      *                   organisation
      * @param serviceName a name for the service that can be displayed to 
      *                    the end user to identify this service
      *
      * @throws UserRejectedInstallException thrown if the end user rejects 
      *                                     the installation
      * @throws NotEnoughResourcesException thrown if the MHP terminal does 
      *                                    not have enough resources,
      *                                    e.g. storage space, available 
      *                                    for the application
      * @throws ServiceAlreadyExistsException thrown if a stored application
      *                                      service with the same 
      *                                      organisation_id and service_id
      *                                      already exists in the terminal
      * @throw java.lang.SecurityException thrown if the application 
      * calling this method does not have an ApplicationStoragePermission
      * with action "create" or "*" for the organisation_id passed in
      * as the parameter. Also thrown if that organisation_id does not match
      * the organisation_id of the calling application.

      */
    public StoredApplicationService createStoredApplicationService( 
		int organisation_id, int service_id, String serviceName) 
		throws NotEnoughResourcesException,
		  UserRejectedInstallException,
		  ServiceAlreadyExistsException;

}





