package org.dvb.smartcard;

/**
 * This class is for permissions related to access to smart cards
 * via the smart card API. A SmartCardPermission contains
 * no name and no actions list. If an application has the SmartCard
 * permission, then it is allowed to access the SmartCard API and
 * any smart cards via that API.
 */

public class SmartCardPermission
	extends java.security.BasicPermission
{
	/**
	 * Creates a new SmartCardPermission. The name parameter
	 * is not used and must be set to empty string "".
	 * Implementations of this version of this specification
	 * shall ignore the name, but it could be taken into use
	 * in future versions of this specification.
	 *
	 * @param name the name of the SmartCardPermission. Not used,
	 * shall be "".
	 */
	public SmartCardPermission(String name)
	{
		super(name);
	}

	/**
	 * Creates a new SmartCardPermission. The name and actions
	 * parameters are not used.
	 * Implementations of this version of this specification
	 * shall ignore the name and actions, but they could be taken
	 * into use in future versions of this specification.
	 * This constructor exists for use by the Policy object to
	 * instantiate new Permission objects.
	 *
	 * @param name the name of the SmartCardPermission. Not used,
	 * shall be "".
	 * @param actions Not used, shall be null.
	 */
	public SmartCardPermission(String name, String actions)
	{
		super(name, actions);
	}
}

